////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// stim.h
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#ifndef	_stim_h_
#define	_stim_h_

#include <systemc>
#include <iostream>
#include <iomanip>
#include "trans.h"

using namespace sc_core;




class stim : public sc_module {
    public:
	sc_in_clk		CLK;
	sc_out < bool >		RSTn;

    private:
	trans_m&		m_m;
	trans_s&		m_s;
	trans_is&		m_is;
	trans_os&		m_os;

	uint16_t		m_base;

    public:
	SC_HAS_PROCESS(stim);
	stim(sc_module_name n, trans_m& m, trans_s& s, trans_is &is, trans_os &os) :
			sc_module(n), m_m(m), m_s(s), m_is(is), m_os(os){
		SC_THREAD(process);
		sensitive << CLK.pos();
	}

    private:
	void process(void);
	int  comp_val(char* n, uint32_t a, uint64_t rd, uint64_t d) {
		if(rd != d) {
			std :: cout << sc_time_stamp() << " stim: " << n << ": read value does not match for address " << std :: hex << a << ", data " << std :: hex << rd << ". (expected " << std :: hex << d << ")" << std :: endl;
			wait(100, SC_NS);
			sc_stop();
		} else {
#ifdef DEBUG_VERBOSE
			std :: cout << sc_time_stamp() << " stim: " << n << ": read value match for address " << std :: hex << a << ", data " << std :: hex << rd << "." << std :: endl;
#endif
		}
		return 0;
	}
		
	uint32_t  sread(uint32_t a) {
		return m_s.read(a);
	}
	uint32_t  sread(uint32_t a, uint32_t d) {
		uint32_t rd = sread(a);
#ifdef DEBUG
		comp_val("check_sread", a, rd, d);
#endif
		return rd;
	}
	uint32_t  mread(uint32_t a, emd_t d) {
		emd_t rd = m_m[a];
#ifdef DEBUG
		comp_val("check_mread", a, rd, d);
#endif
		return rd;
	}
	uint32_t  osread(uint32_t d) {
		uint32_t rd = m_os.read();
#ifdef DEBUG
		comp_val("check_osread", 0, rd, d);
#endif
		return rd;
	}

	void exec_verify(char* s, char* d);
	void exec_verify(char* s, uint32_t d);
	void exec_verify_lazyk(char* s, uint32_t* d, size_t num);
	void exec_verify_lazyk_1(char* s, uint32_t d);
	void exec_verify_lazyk_1_cont(uint32_t d);
	void parse_and_setup_memory(char* s);
	uint32_t parse(char** s);
	void parse_and_verify_stack_memory(char* s);
	void parse_and_verify_stack(char** s, uint32_t base);
	void parse_and_verify_memory(char** s, uint32_t base);
};

#endif	// _stim_h_

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
