////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// trans.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include "trans.h"
#include <iostream>

uint32_t trans_s :: read (uint32_t a)
{
	SREQ	= true;
	SWRITE	= false;
	SA	= a;
	wait(CLK.posedge_event());
	SREQ	= false;
	wait(CLK.posedge_event());

	return SRD;
}

void trans_s :: write (uint32_t a, uint32_t d)
{
	SREQ	= true;
	SWRITE	= true;
	SA	= a;
	SWD	= d;
	wait(CLK.posedge_event());
	SREQ	= false;

	return ;
}

void trans_m :: process_a (void)
{
	MABSY = false;
	wait();
	for(;;) {
		while(MAREQ == false) {
			wait();
		}
		if(MAWRITE == true) {
			emd_t mask = 0;
			for(int i = sizeof(emd_t) - 1; i >= 0; i--) {
				mask <<= 8;
				if((MAS.read() >> i) & 0x1) {
					mask |= 0xff;
				}
			}
			if(MAA.read() >= (1 << PB_MEM_MAX_BITS)) {
				std :: cerr << "error: memory overflow." << std :: endl;
				sc_stop();
			}
			m_data[MAA] = MAD & mask | m_data[MAA] & ~mask;
		} else {
			MABSY = true;
			m_fifo.write(m_data[MAA]);
			MABSY = false;
		}
		wait();
	}
}

void trans_m :: process_r (void)
{
	MRREQ = false;
	wait();
	for(;;) {
		MRD   = m_fifo.read();
		MRREQ = true;
		do {
			wait();
		} while(MRBSY == true);
		MRREQ = false;
	}
}

void trans_is :: write (uint32_t data)
{
	m_fifo.write(data);

	return ;
}

void trans_is :: proc ()
{
	for(;;) {
		ISBSY	= true;
		do {
			wait();
		} while(ISREQ == false);

		ISBSY	= false;
		if(m_fifo.num_available() == 0) {
			ISLAST	= true;
			ISD	= 0;
		} else {
			uint32_t data = m_fifo.read();
			ISLAST	= false;
			ISD	= data;
		}
		wait();
	}

	return ;
}

uint32_t trans_os :: read (void)
{
	OSBSY	= false;
	do {
		wait(CLK.posedge_event());
	} while(OSREQ == false);
	OSBSY	= true;

	return	OSLAST.read() ? 256 : OSD.read();
}



////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
