////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// asm2obj.h
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#ifndef _asm2obj_h_
#define _asm2obj_h_

#include <iostream>

#include <sys/types.h> 
#include <sys/stat.h> 
#include <unistd.h>
#include <stdint.h>

#include "sym.h"
#include "conf.h"


#define SYM_S		0x1ULL
#define SYM_K		(0x1ULL | 0x4)
#define SYM_I		(0x1ULL | 0x8)
#define SYM_L		(0x1ULL | 0xc)
#define SYM_N		(0x1ULL | 0x10)
#define MINT(X)		((X) << 2)
#define CONSA(X)	(((X) << 2 ) | 0x3ULL)
#define SYMT(X)		((X) << 2 | 0x2ULL)

#ifdef PB_DS_BITS_16BIT
  #define CONS(X,Y)	(((X) << 16 ) | Y)
  #define CAR(X)	(((X) >> 16 ) & 0xffff)
  #define CDR(X)	( (X)         & 0xffff)
#else
  #define CONS(X,Y)	(((X) << 32 ) | Y)
  #define CAR(X)	(((X) >> 32 ) & 0xffffffffULL)
  #define CDR(X)	( (X)         & 0xffffffffULL)
#endif

#ifdef PB_DS_BITS_16BIT
  typedef uint32_t	emd_t;
#else
  typedef uint64_t	emd_t;
#endif


#define FNAME_MAX	256

class obj {
    private:
	emd_t			*m_m;
	uint32_t		m_base;
	size_t			m_size;
	uint32_t		m_entry;
	sym			m_sym;

    public:
	obj(void) : m_base(0), m_size(2048) {
		m_m = (emd_t*)malloc(sizeof(emd_t) * m_size);
		if(m_m == 0) {
			std :: cerr << "error: out of memory." << std :: endl;
			abort();
		}
	}

	void		setup_common_functions(void);
	void		compile_file(char* n);
	size_t		size(void) { return m_size; }
	uint32_t	entry(void) { return m_entry; }

	emd_t&		operator[] (uint32_t a) { return m_m[a]; }

    private:
	char*		parse_fun(char* s, char n[256], char* eob);
	uint32_t	parse(char** s, char* eob);
	uint32_t	parse_symbol(char** s, char* eob);
	void		link(void);
};
	

#endif	// _asm2obj_h_

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
