////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// io.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include "io.h"
#include <iostream>

int trans_is_fio :: get_int (void)
{
	if(m_c == 0) m_c = fgetc(m_fp);

	// skip space
	for(; m_c != EOF && isspace(m_c); m_c = fgetc(m_fp));
	if(m_c == EOF) {
		return m_c;
	}

	// get integer
	char buf[32];
	buf[0] = m_c;
	unsigned i;
	for(i = 1; i < (sizeof(buf) - 1) && m_c != EOF && isdigit(m_c);
		m_c = buf[i] = fgetc(m_fp), i++) ;
	if(i == 1 || i == (sizeof(buf) - 1)) {
		m_c = EOF;
		std :: cerr << "error: input stream parse fails: will continue with EOF" << std :: endl;
		return m_c;
	}
	buf[i-1] = '\0';

	// return integer
	return atoi(buf);
}

void trans_is_fio :: proc ()
{
	int	d = 0;
	for(;;) {
		ISBSY	= true;
		do {
			wait();
		} while(ISREQ == false);

		ISBSY	= false;
		if(d != EOF) {
			d = get_int();
		}
		if(d == EOF) {
			ISLAST	= true;
			ISD	= 0;
		} else {
			ISLAST	= false;
			ISD	= d;
		}
		wait();
	}

	return ;
}

void trans_os_fio :: proc ()
{
	for(;;) {
		do {
			wait();
		} while(OSREQ == false);

		if(OSLAST.read() == false) {
			put_int(OSD.read());
		}

		wait();
	}

	return ;
}

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
