////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// seq.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include <stdint.h>
#include "conf.h"
#include "seq.h"

void seq :: process(void)
{
	// execute asynchronus reset
	RSTn = true;
	wait(35, SC_NS);
	RSTn = false;
	wait(60, SC_NS);
	RSTn = true;
	wait();

	// compile from file
	m_obj.setup_common_functions();
	m_obj.compile_file(m_term);

	// dump obj to External memory
	for(unsigned i = 0; i < m_obj.size(); i++) {
		m_m[i] = m_obj[i];
	}

	m_s.write(0, 0x2);			// INIT
	m_s.write(6, m_obj.entry());		// CDR
	m_s.write(2, m_obj.size() << 2);	// FP

	m_s.write(0, 0xd);			// START
	while((sread(0) & 0x1) != 0) {		// wait for end
		wait();
	}
	if(m_s.read(0) != 0) {
		std :: cout << std :: endl;
		std :: cerr << "error: PuzzleBox exit code " << std :: hex << m_s.read(0);
	}

	std :: cout << std :: endl;
	wait(100, SC_NS);
	sc_stop();
}


////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
