////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// sym.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "sym.h"

int sym :: index_of(char* n)
{
	assert(n != 0);
	int idx = find(n);
	if(idx < 0) {
		return alloc(n);
	} else {
		return idx;
	}
}

int sym :: find(char* n)
{
	int len = strlen(n);
	for(int i = 0; i < SYM_TBL_MAX; i++) {
		if(m_table[i].name && strncmp(m_table[i].name, n, len+1) == 0) {
			return i;
		}
	}

	return -1;	// not found
}

int sym :: alloc(char* n)
{
	int len = strlen(n);
	for(int i = 0; i < SYM_TBL_MAX; i++) {
		if(m_table[i].name == 0) {
			m_table[i].name = (char*) malloc(len+1);
			strncpy(m_table[i].name, n, len + 1);
			m_table[i].term = 0;

			return i;
		}
	}

	return -1;	// no space
}

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
