<?php
// $Id: rdbomanager.mysql.php,v 1.2 2003/06/15 12:42:18 haruki Exp $
//
// RdbObject and its Manager
//
// Copyright (C) Haruki Setoyama <pwaf.haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
/**
* rdbObjectManager_mysql
*
* @since 2003.06
* @access public
*/
class rdbObjectManager_mysql extends rdbObjectManager
{
    var $cache = array();

    function rdbObjectManager_mysql()
    {
        $this->rdbObjectManager();
    }

    function clearCache()
    {
        unset($this->cache);
        $this->cache = array();
    }

    ///// private functions

    function _query($sql)
    {
        $this->_log($sql);
        $result = mysql_query($sql, $this->linkid);
        if (! $result)
        {
            $this->_trigger_error('_query()::Query error. '.mysql_errno().' : '.mysql_error()
                                , E_USER_WARNING);
//echo htmlspecialchars($sql).'<br>';
            return false;
        }
        return $result;
    }

    function &_get_result($sql)
    {
        $result = $this->_query($sql);
        if (! $result) return false;
        $ret_objs = array();
        while($ret = mysql_fetch_assoc($result))
        {
            $pkey = $ret[$this->pkey_column];
            if(! isset($this->cache[$pkey]))
            {
                $this->cache[$pkey] = $this->rdbObject;
                $this->cache[$pkey]->dbRawData = $ret;
            }
            $ret_objs[$pkey] = $this->cache[$pkey];
        }
        return $ret_objs;
    }

    ///// open

    function &openAll()
    {
        $sql = 'SELECT * FROM '.$this->table;
        return $this->_get_result($sql);
    }

    function openOne($pkey)
    {
        if(isset($this->cache[$pkey])) return $this->cache[$pkey];

        $sql = sprintf("SELECT * FROM %s WHERE %s = %d"
                    ,$this->table, $this->pkey_column, $pkey);
        if (! ($result = $this->_query($sql))) return null;
        $ret = mysql_fetch_assoc($result);
        if($ret == false)
        {
            $this->_trigger_error('openOne()::pkey not exists', E_USER_NOTICE);
            return null;
        }
        $this->cache[$pkey] = $this->rdbObject;
        $this->cache[$pkey]->dbRawData = $ret;
//print_r($ret);
        return $this->cache[$pkey];
    }

    function &openMany($pkeys)
    {
        $where = $this->pkey_column.'='.implode(' OR '.$this->pkey_column.'=', $pkeys);

        $sql = 'SELECT * FROM '.$this->table.' WHERE '.$where;
        return $this->_get_result($sql);
    }

    function &openWith($varname, $value, $opetator ='=')
    {
        $sql = 'SELECT * FROM '.$this->table.' WHERE '
                .$this->renderComparison($varname, $value, $opetator);
        return $this->_get_result($sql);
    }

    // this is not so safe. BE CAREFUL!
    function &openWhere($where)
    {
        $where = trim(preg_replace('/([^\\\\])\$([a-zA-Z_][a-zA-Z_0-9]*)/e'
                        , "'\\1'.\$this->column['\\2']"
                        , ' '.$where));

        $sql = sprintf("SELECT * FROM %s WHERE %s", $this->table, $where);
        return $this->_get_result($sql);
    }

    function &openConditional($condition)
    {
        $where = $condition->render($this);
        $limit = '';
        if(isset($condition->start)) $limit .= intval($condition->start).',';
        if(isset($condition->limit)) $limit .= intval($condition->limit).'';
        if(!empty($limit)) $where .= ' LIMIT '.$limit;
        $sql = sprintf("SELECT * FROM %s %s", $this->table, $where);
        return $this->_get_result($sql);
    }

    function &openJoin($join_varname, $varname, $value, $opetator ='=')
    {
        if(! isset($this->element[$join_varname]->option['related']))
        {
            $this->_trigger_error('openJoin()::no relational table', E_USER_NOTICE);
            return false;
        }
        $m =& singleton::getInstance($this->element[$join_varname]->option['related']);

        if(! in_array($varname, $m->actuals))
        {
            $this->_trigger_error('openJoin()::no variable name in the relational table', E_USER_NOTICE);
            return false;
        }

        if(isset($this->element[$join_varname]->option['fkey']))
        {
            $a_column = $m->column[$this->element[$join_varname]->option['fkey']];
            $b_column = $this->pkey_column;
        }
        else
        {
            $a_column = $m->column[$m->pkey];
            $b_column = $this->column[$join_varname];
        }

        $sql = sprintf("SELECT b.* FROM %s as a, %s as b WHERE (a.%s = b.%s) AND (a.%s)"
                        ,$m->table ,$this->table
                        ,$a_column ,$b_column
                        ,$m->renderComparison($varname, $value, $opetator) );

        return $this->_get_result($sql);
    }

    function &openJoins($joins)
    {
        $tbl[] = $this->table.' as a';
        $where = array();

        foreach($joins as $key => $join)
        {
            if(! isset($this->element[$join[0]]->option['related']))
            {
                $this->_trigger_error('openJoins()::no relational table', E_USER_NOTICE);
                continue;
            }

            $m =& singleton::getInstance($this->element[$join[0]]->option['related']);
            if(! in_array($join[1], $m->actuals))
            {
                $this->_trigger_error('openJoins()::no variable name in the relational table', E_USER_NOTICE);
                continue;
            }

            $tbl[] = $m->table.' as b'.$key;

            if(isset($this->element[$join[0]]->option['fkey']))
            {
                $where[] = sprintf("a.%s = b%s.%s",
                                $this->pkey_column,
                                $key, $m->column[$this->element[$join[0]]->option['fkey']]
                            );
            }
            else
            {
                $where[] = sprintf("a.%s = b%s.%s",
                                $this->column[$join[0]],
                                $key, $m->column[$m->pkey]
                            );
            }
            if(!isset($join[3])) $join[3] = '=';
            $where[] = $m->renderComparison($join[1], $join[2], $join[3]);
        }
        if(empty($where)) return false;

        $sql = sprintf("SELECT a.* FROM %s WHERE %s"
                        ,implode(', ', $tbl)
                        ,implode(' AND ', $where));

        return $this->_get_result($sql);

    }

    ///// pkey

    function getPkey($condition)
    {
        $where = $condition->render($this);
        $limit = '';
        if(isset($condition->start)) $limit .= intval($condition->start).',';
        if(isset($condition->limit)) $limit .= intval($condition->limit).'';
        if(!empty($limit)) $where .= ' LIMIT '.$limit;
        $sql = sprintf("SELECT %s FROM %s %s", $this->pkey_column, $this->table, $where);
        return $this->_get_pkeys($sql);
    }

    function _get_pkeys($sql)
    {
        $result = $this->_query($sql);
        if (! $result) return false;
        $keys = array();
        while($ret = mysql_fetch_assoc($result))
            $keys[] = $ret[$this->pkey_column];
        return $keys;
    }

    /////

    function count($condition)
    {
        $sql = sprintf("SELECT COUNT(*) FROM %s %s", $this->table, $condition->render($this));
        $result = $this->_query($sql);
        if (! $result) return false;
        $cnt = array();
        while($ret = mysql_fetch_row($result))
        {
            $cnt[] = $ret[0];
        }
        return $cnt;
    }

    ///// save

    function save(&$object, $varnames =null)
    {
        if(!$this->_valid_rdbobject($object)) return false;
        if ($object->pkey() > 0)
        {
        // Update
            return $this->_update($object, $varnames);
        }
        else
        {
        // Insert new record
            return $this->_insert($object);
        }
    }

    function saveAsNew(&$object)
    {
        if(!$this->_valid_rdbobject($object)) return false;
        return $this->_insert($object);
    }

    function _preSave(&$object, $varnames)
    {
        $tmp_object = $object;
        foreach($varnames as $varname)
        {
            $ret = $this->element[$varname]->preSave($tmp_object);
            if(! $ret) return false;
        }
        $object = $tmp_object;
        return true;
    }

    function _update(&$object, $varnames)
    {
        if(!isset($varnames))
            $vars = $this->actuals;
        else
            $vars = array_intersect($this->actuals, $varnames);

        $ret = $this->_preSave(&$object, $vars);
        if(! $ret) return false;

        $data = array();
        $object->change[$this->pkey] = null;

        foreach($vars as $varname){
            if($object->change[$varname])
            {
                $column = $this->column[$varname];
                if($object->dbRawData[$column] !== null)
                    $data[] = $column.' = '.$this->quote($object->dbRawData[$column], $varname);
                else
                    $data[] = 'NULL';
            }
        }
        $pkey = $object->pkey();
        if(! empty($data))
        {
            $sql = sprintf("UPDATE %s SET %s WHERE %s = %u"
                        , $this->table, implode(',',$data)
                        , $this->pkey_column, $pkey);
            if (! $this->_query($sql)) return false;
            if(! mysql_affected_rows($this->linkid))
            {
                $this->_trigger_error('_update()::row '.$pkey.' not exists', E_USER_NOTICE);
                return false;
            }
        }

        foreach($vars as $varname)
            $object->change[$varname] = null;
        $this->cache[$pkey] = null;
        return $pkey;
    }

    function _insert(&$object)
    {
        $ret = $this->_preSave(&$object, $this->actuals);
        if(! $ret) return false;

        $fields = array();
        $data = array();
        foreach($this->actuals as $varname){
            //if($varname == $this->pkey) continue;
            $column = $this->column[$varname];
            $fields[] = $column;
            $data[] = $this->quote($object->dbRawData[$column], $varname);
        }
        $sql = sprintf("INSERT INTO %s ( %s ) VALUES ( %s )"
                        , $this->table, implode(',',$fields), implode(',',$data));
        if (! $this->_query($sql)) return false;
        $id = mysql_insert_id($this->linkid);
        if($id <= 0)
        {
            trigger_error(get_class($this).'::_insert()::fail to insert. ', E_USER_WARNING);
            return false;
        }

        $object->dbRawData[$this->pkey_column] = $id;
        $object->change = array();
        $this->cache[$id] = $object;
        return $id;
    }

    ///// delete

    function delete(&$object)
    {
        if(!$this->_valid_rdbobject($object)) return false;

        foreach($this->virtuals as $name)
        {
            $this->element[$name]->deleteRelated($object);
        }

        $pkey = $object->pkey();
        $sql = sprintf("DELETE FROM %s WHERE %s = %u"
                    , $this->table, $this->pkey_column, $pkey);
        if (! $this->_query($sql)) return false;
        $object = null;
        $this->cache[$pkey] = null;
        if(! mysql_affected_rows($this->linkid))
        {
            $this->_trigger_error('delete()::row '.$pkey.' may be already deleted.', E_USER_NOTICE);
        }
        return true;
    }

    /////

    function quote($value, $varname)
    {
        if($value === null)
            return 'NULL';
        elseif(!$this->numeric[$varname] || !is_numeric($value))
            return '\''.mysql_escape_string($value).'\'';
        else
            return $value;
    }

    /////

    function renderGruop($gruops)
    {
        return $this->renderOrder($gruops);
    }

}

?>