#ifndef _INCLUDE_TREEMATCH_H_
#define _INCLUDE_TREEMATCH_H_

#include <stdio.h>
#include <stdlib.h>
#include "boolean.h"

typedef struct node *Node;
typedef struct leaf *Leaf;

#define FOUR 4
struct node {
   int step;
   double x, y, size;
   Node next[FOUR];
   Leaf obj;
};

struct leaf {
   double x, y, mag;
   int nmatch;
   Leaf *match, adopted;
   Node up;
   void *data;
};

Leaf create_Leaf(double x, double y, double mag, void *data);
void dematch_Leaf(int ncat, Leaf *cat);
Node create_Node(double x, double y, double size);
void destroy_Node(Node p);
int which_node(Node p, Leaf q);
void make_next_tree(Node tree);
void add_obj_to_tree(Node tree, Leaf obj);
void add_obj_to_match(Leaf obj, Leaf target);
void tree_match(Node tree, Leaf obj, double del, double del2);
void tree_match_pre(Node tree, Leaf obj, double del, double del2);
void trans_Leaf_xy(int ncat, Leaf *cat, double *coef);
void make_treematch(int nobj, Leaf *obj, int nref, Leaf *ref, double x, double y, double size, double tol);
void make_treematch_pre(int nobj, Leaf *obj, int nref, Leaf *ref, double x, double y, double size, double tol);
int count_adopted(int ncat, Leaf *cat);
Leaf get_brightest_unadopted(Leaf p);

#endif
