#!/usr/bin/env python

import os
import sys
import re


def create(myflat, bandarr):

    SCRIPTDIR = os.path.realpath(os.path.dirname(sys.argv[0]))
    cprog = 'twflatcom'
    
    for band in bandarr:
        os.system("%s/%s %sflatlist %s%s.fits" % (SCRIPTDIR, cprog, band, band, myflat))



if __name__ == "__main__":
    
    argvs = sys.argv
    argc = len(argvs)
    bandarr = ['j', 'h', 'k']

    if argc < 2:
        print 'usage: twfcom.py myflat'
        print 'twfcom.py creates [j|h|k]myflat.fits'
        print 'option'
        print '-band=string (ex. -band=j -band=h,k)'
        sys.exit()

    for item in argvs:
        if item.startswith('-band'):
            if not re.search('[jhk]', item[6:]):
                print 'Invalid : '+item
                sys.exit()
            bandarr = item[6:].split(',')

    flag = 0
    for band in bandarr:
        if not os.path.exists(band+'flatlist'):
            print '%sflatlist not found' % band
            flag += 1

    if flag > 0:
        sys.exit()

    myflat = argvs[1]

    create(myflat, bandarr)



