#include "tmat.h"

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
/*
#include <stddef.h>
*/ 

void rotmat( int iaxis, double theta, double *r ) 
{ 
	int	i, j ; 
	double	c, s ; 

	for ( i = 0 ; i < NDIM ; i++ ) { 
		for ( j = 0 ; j < NDIM ; j++ ) 
			r[i*NDIM+j] = 0.0 ; 
	} 

	c = cos( theta ) ; 
	s = sin( theta ) ; 

	if ( iaxis == 1 ) { 
		r[0] = 1.0 ; 
		r[4] = c ; 
		r[5] = s ; 
		r[7] = -s ; 
		r[8] = c ; 
	} 
	if ( iaxis == 2 ) { 
		r[0] = c ; 
		r[2] = -s ; 
		r[4] = 1.0 ; 
		r[6] = s ; 
		r[8] = c ; 
	} 
	if ( iaxis == 3 ) { 
		r[0] = c ; 
		r[1] = s ; 
		r[3] = -s ; 
		r[4] = c ; 
		r[8] = 1.0 ; 
	} 
} 

void txexyz( double xi, double eta, double *x ) 
{ 
	double	eps = 1.0e-15 ; 

	if ( eta > M_PI / 2.0 ) { 
		if ( fabs( fabs( eta ) - M_PI / 2.0 ) <= eps ) 
			eta = M_PI / 2.0 ; 
	} 
	if ( eta < - M_PI / 2.0 ) { 
		if ( fabs( fabs( eta ) - M_PI / 2.0 ) <= eps ) 
			eta = - M_PI / 2.0 ; 
	} 
	if ( fabs ( eta ) < eps ) 
			eta = 0.0 ; 
	if ( fabs( eta ) > M_PI / 2.0 ) { 
		fprintf( stderr, "Error! Function txexyz --- Invalid value of angle eta!\n\teta=%20.15f\nAngle eta ( 2nd argument ) should be between -pi/2 and pi/2! \n", eta ) ; 
		printf( "eta = %20.15f \n", eta ) ; 
	} 

	x[0] = cos( eta ) * cos( xi ) ; 
	x[1] = cos( eta ) * sin( xi ) ; 
	x[2] = sin( eta ) ; 
} 

void mult0( double *r, double *x, double *y ) 
{ 
	int i, j ; 
	
	for ( i = 0 ; i < NDIM ; i++ ) { 
		y[i] = 0.0 ; 
		for ( j = 0 ; j < NDIM ; j++ ) 
			y[i] += r[NDIM*i+j] * x[j] ; 
	} 
} 

