# coding: utf-8
import Tkinter
import ttk
import weakref
import inspect
from term import Terminal, event, connect
from tkext import Entry, Checkbutton
from utils.singleton import Singleton

class Root(object):
    __metaclass__ = Singleton
    def __init__(self):
        self.children = {}
    def destroy(self):
        for c in self.children.values(): c.destroy()
        
class Logic(object):
    def __init__(self,master=None,name=None):
        self.children = {}
        if master == None:
            self.master = Root()
        else:
            self.master = master
        if name == None:
            self._name = repr(id(self))
        else:
            self._name = name
        if self._name in self.master.children: # master.childrenにおけるidの唯一性を保証する
            self.master.children[self._name].destroy()
        self.master.children[self._name] = self
    def _remove_from_master(self): # master.childrenから自身へのオブジェクト参照を廃棄する
        if self._name in self.master.children:
            del self.master.children[self._name]
    def destroy(self):
        ''' Destroy this and all descendants nodes.'''
        for c in self.children.values(): c.destroy() # 子オブジェクトを巡回してdestroy()をコールする
        self._remove_from_master() # 親オブジェクトのchildren辞書から自身の参照を削除する
        # ^^^ 辞書の巡回中に辞書を変更しちゃって大丈夫？
        # self.children.clear() で一気に削除するほうが行儀いいのでは？
        # self.master.children.clear()

Parts = Logic

class Panel(Tkinter.Frame,object):
    CONNECTION = [] # logic: self
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.layout()
    def layout(self): pass
    def widget(self,name):
        #
        # 論理的に最も近い name のウィジェットを検索する
        #
        if name in self.children: return self.children[name]
        # ！！下層へのウィジェットの検索を追加したい
#        for key,value in self.children.iteritems():
#            self.children[key]
        return
    def connect(self,logic):
        def core(logic,name,wname):
            widget = self.widget(wname)
            if widget is None: return False
            if isinstance(widget,BaseEquipment):
                connect((logic,name),(widget.logic,'value'))
            else:
                connect((logic,name),(widget,'value'))
            return True
        terms = inspect.getmembers(logic.__class__,lambda x: isinstance(x,Terminal))
        for name,value in terms:
            if not core(logic,name,name): continue
        for name,wname in self.CONNECTION:
            if not core(logic,name,wname): continue
            
class Config(ttk.Notebook):
    def __init__(self,master=None,panel_klass=None,**kw):
        ttk.Notebook.__init__(self,master,**kw)
        self.subpanel = weakref.WeakValueDictionary()
        if panel_klass is None: return
        for key,klass in panel_klass.iteritems():
            self.subpanel[key] = klass(self)
            self.add(self.subpanel[key],text=key.capitalize())

class InteractiveWidget(Tkinter.Frame,object):
    interval = Terminal(20)
    value = Terminal()
    @event(False)
    def switch(self):
        if self.switch:
            self._polling()
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.id = None
        Entry(self,name='interval').pack()
        Checkbutton(self,name='switch',text='interactive').pack()
        for name in ['interval','switch']:
            connect((self,name),(self.children[name],'value'))
    def _polling(self):
        if self.switch:
            self.value
            self.id = self.after(self.interval,self._polling)
        else:
            if self.id: # self.id is not None
                self.after_cancel(self.id)
                self.id = None

class Layout(Tkinter.Frame):
    def __init__(self,master=None,panel_klass=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.panel = weakref.WeakValueDictionary()
        self.config_panel = weakref.WeakValueDictionary()
        self.config_panel_klass = {}
        if panel_klass is None: return
        #
        for key,klass in panel_klass.iteritems():
            if key == 'config':
                self.panel[key] = self.config_panel
                for mykey,myklass in inspect.getmembers(klass,inspect.isclass):
                    self.config_panel_klass[mykey.lower()] = myklass
                continue
            self.panel[key] = klass(self)
        if not 'rack' in self.panel: self.panel['rack'] = Panel(self)
        self.layout(self.panel)
    def layout(self,panel):
        if 'toolbar' in panel:
            panel['toolbar'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'plot' in panel:
            panel['plot'].grid(row=1,column=0,rowspan=2,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        if 'control' in panel:
            panel['control'].grid(row=1,column=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'rack' in panel:
            panel['rack'].grid(row=2,column=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'status' in panel:
            panel['status'].grid(row=3,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        self.grid_columnconfigure(0,weight=1)
    @property
    def rack(self):
        if 'rack' in self.panel:
            return self.panel['rack']
        else:
            return
    def connect(self,logic):
        for name in ['plot','control','status','toolbar','rack']:
            if name in self.panel: self.panel[name].connect(logic)
    @property
    def logic(self): return self.master.logic
    def popup_config(self,**kw):
        if not self.config_panel_klass: return
        c = Config(Tkinter.Toplevel(self),self.config_panel_klass,**kw)
        c.pack(expand=True,fill=Tkinter.X)
        for key,value in c.subpanel.iteritems():
            self.panel['config'][key] = value
            value.connect(self.logic)

class PlotLayout(Layout):
    def __init__(self,master=None,panel_klass=None,cnf={},**kw):
        Layout.__init__(self,master,panel_klass,cnf,**kw)
        self.config_panel_klass['control'] = panel_klass['control']
    def connect(self,logic):
        for name in ['plot']:
            if name in self.panel: self.panel[name].connect(logic)
    def layout(self,panel):
        if 'plot' in panel:
            panel['plot'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        self.grid_columnconfigure(0,weight=1)
        
class BaseEquipment(object):
    def __init__(self,logic_klass=None,layout_klass=Layout,mount=True,panel_klass={}):
        self.logic_klass = logic_klass
        self.panel_klass = {}
        self.extract('plot',logic_klass,**panel_klass)
        self.extract('control',logic_klass,**panel_klass)
        self.extract('config',logic_klass,**panel_klass)
        if layout_klass:
            layout = layout_klass(self,self.panel_klass)
            layout.pack(expand=True,fill=Tkinter.BOTH)
            self._layout = weakref.ref(layout)
        else:
            self._layout = None
        if mount: self.mount(logic_klass(self))
    def mount(self,logic):
        self._logic = weakref.ref(logic)
        self.layout.connect(logic)
        return self
    @property
    def layout(self):
        if self._layout:
            return self._layout()
        else:
            return
    def extract(self,name,logic_klass,**kw):
        klass_name = '%s_klass' % name
        if klass_name in kw:
            self.panel_klass[name] = kw[klass_name]
            del kw[klass_name]
        else:
            try: getattr(logic_klass,name.capitalize())
            except AttributeError: pass
            else: self.panel_klass[name] = getattr(logic_klass,name.capitalize())
    @property
    def panel(self):
        return self.layout.panel
    @property
    def logic(self):
        if self._logic:
            return self._logic()
        else:
            return
        
class Equipment(Tkinter.Frame,BaseEquipment):
    def __init__(self,master=None,logic_klass=None,layout_klass=Layout,mount=True,panel_klass={},cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        BaseEquipment.__init__(self,logic_klass,layout_klass,True,panel_klass)
    def pack(self,*args,**kw):
        Tkinter.Frame.pack(self,*args,**kw)
        return self
    def grid(self,*args,**kw):
        Tkinter.Frame.grid(*args,**kw)
        return self
        
class Embed(Tkinter.LabelFrame,BaseEquipment):
    def __init__(self,master=None,logic_klass=None,layout_klass=PlotLayout,mount=True,panel_klass={},cnf={},**kw):
        Tkinter.LabelFrame.__init__(self,master,cnf,**kw)
        BaseEquipment.__init__(self,logic_klass,layout_klass,True,panel_klass)
        if logic_klass: self.config(text=logic_klass.__name__)
    def pack(self,*args,**kw):
        Tkinter.LabelFrame.pack(self,*args,**kw)
        return self
    def grid(self,*args,**kw):
        Tkinter.LabelFrame.grid(*args,**kw)
        return self
        