# coding: utf-8

import Tkinter
import weakref

class TableBuilder:
    def __init__(self,master,column=2,description=None):
        self.master = weakref.ref(master)
        self.column = column
        col, row    = master.grid_size()
        self.cursor = (0, row)
        if description: # description is not None
            for klass,opt,grid in description:
                self.add(klass,**opt)
                self.grid(**grid)
    def add(self,klass,*args,**kwargs):
        self._item = weakref.ref(klass(self.master(),*args,**kwargs))
        return self
    def grid(self,row=None,column=None,rowspan=None,columnspan=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S,**kwargs):
        # rowspan は無視
        column, row = self.cursor
        self._item().grid(row=row,column=column,columnspan=columnspan,sticky=sticky,**kwargs)
        #self.master().grid_rowconfigure(row,weight=1)
        self.master().grid_columnconfigure(column,weight=1)
        if (column + columnspan) <= (self.column - 1):
            column = column + columnspan
        else:
            column = 0
            row = row + 1
        self.cursor = (column, row)
        return self
    def item(self):
        return self._item()
    def bind(self,*args,**kwargs):
        return self.item().bind(*args,**kwargs)
