# -*- coding: utf-8 -*-

#	Copyright © 2014 dyknon
#
#	This file is part of Pylib-nicovideo.
#
#	Pylib-nicovideo is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys

def dummy_logger(string):
	pass

def logger_auto_lf(string):
	sys.stderr.write("{}\n".format(string))

def set_loglevel(level):
	global debug
	global verbose
	global info
	global warning 
	global error 
	global fatal 
	global panic 
	if isinstance(level, int):
		if level >= 7:
			debug = logout
		else:
			debug = dummy_logger
		if level >= 6:
			verbose = logout
		else:
			verbose = dummy_logger
		if level >= 5:
			info = logout
		else:
			info = dummy_logger
		if level >= 4:
			warning = logout
		else:
			warning = dummy_logger
		if level >= 3:
			error = logout
		else:
			error = dummy_logger
		if level >= 2:
			fatal = logout
		else:
			fatal = dummy_logger
		if level >= 1:
			panic = logout
		else:
			panic = dummy_logger
	else:
		if level.isdecimal():
			set_loglevel(int(level))
		else:
			for lv in range(len(levelname)):
				if levelname[lv] == level:
					set_loglevel(lv)
					break
			else:
				error("そんなログレベル無いよ: " + str(level))

logout = logger_auto_lf
levelname = ["quiet", "panic", "fatal", "error",
			 "warning", "info", "verbose", "debug"]

panic = logout
fatal = logout
error = logout
warning = logout
info = logout
verbose = dummy_logger
debug = dummy_logger
