#include "basic_api.h"


PyObject *
senna_sen_init(PyObject *self, PyObject *args)
{
  sen_rc rc;
  if (!PyArg_ParseTuple(args, "")) {
    return NULL;
  }
  rc = sen_init();
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_fin(PyObject *self, PyObject *args)
{
  sen_rc rc;
  if (!PyArg_ParseTuple(args, "")) {
    return NULL;
  }
  rc = sen_fin();
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_index_create(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_index *index;
  PyObject *index_obj;
  char *path = "";
  int key_size = 0;
  int flags = SEN_INDEX_NGRAM|SEN_INDEX_NORMALIZE;
  sen_encoding encoding = sen_enc_utf8;
  int initial_n_segments = 0;
  static char *kwlist[] = {"path", "key_size", "flags", "initial_n_segments", "encoding", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "s|iiii", kwlist,
                                   &path, &key_size, &flags, &initial_n_segments, &encoding)) {
    return NULL;
  }
  index = sen_index_create(path, key_size, flags, initial_n_segments, encoding);
  if (!index) {
    return Py_BuildValue("");
  }
  index_obj = PyCObject_FromVoidPtr((void*)index, NULL);
  return Py_BuildValue("O", index_obj);
}


PyObject *
senna_sen_index_open(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_index *index;
  PyObject *index_obj;
  char *path = "";
  static char *kwlist[] = {"path", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "s", kwlist, &path)) {
    return NULL;
  }
  index = sen_index_open(path);
  if (!index) {
    return Py_BuildValue("");
  }
  index_obj = PyCObject_FromVoidPtr((void*)index, NULL);
  return Py_BuildValue("O", index_obj);
}


PyObject *
senna_sen_index_close(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_index *index;
  PyObject *index_obj;
  static char *kwlist[] = {"index", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &index_obj)) {
    return NULL;
  }
  index = (sen_index*)PyCObject_AsVoidPtr(index_obj);
  rc = sen_index_close(index);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_index_remove(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  char *path = "";
  static char *kwlist[] = {"path", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "s", kwlist, &path)) {
    return NULL;
  }
  rc = sen_index_remove(path);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_index_rename(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  char *old_name = "";
  char *new_name = "";
  static char *kwlist[] = {"old_name", "new_name", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "ss", kwlist, &old_name, &new_name)) {
    return NULL;
  }
  rc = sen_index_rename(old_name, new_name);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_index_upd(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_index *index;
  PyObject *index_obj;
  char *key = "";
  char *oldvalue = "";
  char *newvalue = "";

  static char *kwlist[] = {"index", "key", "oldvalue", "newvalue", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "Osss", kwlist,
                                   &index_obj, &key, &oldvalue, &newvalue)) {
    return NULL;
  }
  index = (sen_index*)PyCObject_AsVoidPtr(index_obj);
  rc = sen_index_upd(index, key, oldvalue, newvalue);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_index_sel(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_index *index;
  PyObject *index_obj;
  sen_records *records;
  PyObject *records_obj;
  char *string = "";

  static char *kwlist[] = {"index", "string", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "Os", kwlist, &index_obj, &string)) {
    return NULL;
  }
  index = (sen_index*)PyCObject_AsVoidPtr(index_obj);
  records = sen_index_sel(index, string);
  if (!records) {
    return Py_BuildValue("");
  }
  records_obj = PyCObject_FromVoidPtr((void*)records, NULL);
  return Py_BuildValue("O", records_obj);
}


PyObject *
senna_sen_records_next(PyObject *self, PyObject *args, PyObject *keywds)
{
  int keysize = 0;
  sen_records *records;
  PyObject *records_obj;
  static char *kwlist[] = {"records", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &records_obj)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  keysize = sen_records_next(records, NULL, 0, NULL);
  return Py_BuildValue("i", keysize);
}


PyObject *
senna_sen_records_rewind(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_records *records;
  PyObject *records_obj;
  static char *kwlist[] = {"records", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &records_obj)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  rc = sen_records_rewind(records);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_records_curr_score(PyObject *self, PyObject *args, PyObject *keywds)
{
  int score;
  sen_records *records;
  PyObject *records_obj;
  static char *kwlist[] = {"records", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &records_obj)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  score = sen_records_curr_score(records);
  return Py_BuildValue("i", score);
}


PyObject *
senna_sen_records_curr_key(PyObject *self, PyObject *args, PyObject *keywds)
{
  int keysize = 0;
  sen_records *records;
  PyObject *records_obj;
  char *keybuf;
  PyObject *keybuf_obj;
  int bufsize = SEN_SYM_MAX_KEY_SIZE;
  static char *kwlist[] = {"records", "bufsize", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O|i", kwlist,
                                   &records_obj, &bufsize)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  keybuf = PyMem_Malloc(bufsize);
  keysize = sen_records_curr_key(records, keybuf, bufsize);
  if (keysize == 0) {
    keybuf_obj = Py_BuildValue("");
  } else {
    keybuf_obj = Py_BuildValue("s", keybuf);
  }
  PyMem_Free(keybuf);
  return keybuf_obj;
}


PyObject *
senna_sen_records_nhits(PyObject *self, PyObject *args, PyObject *keywds)
{
  int nhits;
  sen_records *records;
  PyObject *records_obj;
  static char *kwlist[] = {"records", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &records_obj)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  nhits = sen_records_nhits(records);
  return Py_BuildValue("i", nhits);
}


PyObject *
senna_sen_records_find(PyObject *self, PyObject *args, PyObject *keywds)
{
  int score;
  sen_records *records;
  char *key = "";
  PyObject *records_obj;
  static char *kwlist[] = {"records", "key", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "Os", kwlist, &records_obj, &key)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  score = sen_records_find(records, key);
  return Py_BuildValue("i", score);
}


PyObject *
senna_sen_records_close(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_records *records;
  PyObject *records_obj;
  static char *kwlist[] = {"records", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &records_obj)) {
    return NULL;
  }
  records = (sen_records*)PyCObject_AsVoidPtr(records_obj);
  rc = sen_records_close(records);
  return Py_BuildValue("i", rc);
}
