#include <Python.h>
#include <senna.h>
#include "basic_api.h"
#include "advanced_api.h"
#include "snippet_api.h"


static PyObject *SennaError;


static PyMethodDef SennaMethods[] = {
  {"sen_init",  senna_sen_init, METH_VARARGS,
   "Initialize Senna library."},
  {"sen_fin",  senna_sen_fin, METH_VARARGS,
   "Finalize Senna library."},
  {"sen_index_create",  (PyCFunction)senna_sen_index_create, METH_VARARGS | METH_KEYWORDS,
   "Create Senna index and return it."},
  {"sen_index_open",  (PyCFunction)senna_sen_index_open, METH_VARARGS | METH_KEYWORDS,
   "Open Senna index."},
  {"sen_index_close",  (PyCFunction)senna_sen_index_close, METH_VARARGS | METH_KEYWORDS,
   "Close Senna index."},
  {"sen_index_remove",  (PyCFunction)senna_sen_index_remove, METH_VARARGS | METH_KEYWORDS,
   "Remove Senna index files."},
  {"sen_index_rename",  (PyCFunction)senna_sen_index_rename, METH_VARARGS | METH_KEYWORDS,
   "Rename Senna index files."},
  {"sen_index_upd",  (PyCFunction)senna_sen_index_upd, METH_VARARGS | METH_KEYWORDS,
   "Update (or insert into or delete from) Senna index."},
  {"sen_index_sel",  (PyCFunction)senna_sen_index_sel, METH_VARARGS | METH_KEYWORDS,
   "Search for document whose value contains string."},
  {"sen_records_next",  (PyCFunction)senna_sen_records_next, METH_VARARGS | METH_KEYWORDS,
   "Advance to the next record the current record if it is possible. Return 0 if fail, otherwise return length of the key of current record. "},
  {"sen_records_rewind",  (PyCFunction)senna_sen_records_rewind, METH_VARARGS | METH_KEYWORDS,
   "The current record is cleared. To read records again from the first records, a call to sen_records_next() is needed."},
  {"sen_records_curr_score",  (PyCFunction)senna_sen_records_curr_score, METH_VARARGS | METH_KEYWORDS,
   "Return score of the current record (goodness of relevant for search query)."},
  {"sen_records_curr_key",  (PyCFunction)senna_sen_records_curr_key, METH_VARARGS | METH_KEYWORDS,
   "Return length of the key of current record. If current record doesn't exist, return None"},
  {"sen_records_nhits",  (PyCFunction)senna_sen_records_nhits, METH_VARARGS | METH_KEYWORDS,
   "Return the number of records which are included in records."},
  {"sen_records_find",  (PyCFunction)senna_sen_records_find, METH_VARARGS | METH_KEYWORDS,
   "Find record which corresponds to given key in the records, return score value ifsuch record exist."},
  {"sen_records_close",  (PyCFunction)senna_sen_records_close, METH_VARARGS | METH_KEYWORDS,
   "Release the records instance."},
  {"sen_sym_open",  (PyCFunction)senna_sen_sym_open, METH_VARARGS | METH_KEYWORDS,
   "Open symbol table data structure."},
  {"sen_sym_info",  (PyCFunction)senna_sen_sym_info, METH_VARARGS | METH_KEYWORDS,
   "Return the number of records which are correspond to given key_size, flags and encoding of a sen_sym instance."},
  {"sen_sym_close",  (PyCFunction)senna_sen_sym_close, METH_VARARGS | METH_KEYWORDS,
   "Close symbol table data structure."},
  {"sen_sym_size",  (PyCFunction)senna_sen_sym_size, METH_VARARGS | METH_KEYWORDS,
   "Get the number of records of symbol table."},
  {"sen_sym_at",  (PyCFunction)senna_sen_sym_at, METH_VARARGS | METH_KEYWORDS,
   "Get the sen_id of given key."},
  /*
  {"sen_sym_inspect",  (PyCFunction)senna_sen_sym_inspect, METH_VARARGS | METH_KEYWORDS,
   "Inspect sen_sym."},
  {"sen_sym_inspect_term",  (PyCFunction)senna_sen_sym_inspect_term, METH_VARARGS | METH_KEYWORDS,
   "Inspect term in sen_sym from given sen_id."},
  */
  {"sen_snip_open",  (PyCFunction)senna_sen_snip_open, METH_VARARGS | METH_KEYWORDS,
   "Makes an instance of sen_snip and returns it."},
  {"sen_snip_close",  (PyCFunction)senna_sen_snip_close, METH_VARARGS | METH_KEYWORDS,
   "Destructs an instance of sen_snip."},
  {"sen_snip_add_cond",  (PyCFunction)senna_sen_snip_add_cond, METH_VARARGS | METH_KEYWORDS,
   "Specifies a word for searching and a string which is added before and after of the it."},
  {"sen_snip_exec",  (PyCFunction)senna_sen_snip_exec, METH_VARARGS | METH_KEYWORDS,
   "Creates snippets, but doesn't return it."},
  {"sen_snip_get_result",  (PyCFunction)senna_sen_snip_get_result, METH_VARARGS | METH_KEYWORDS,
   "Returns a snippet which is made in sen_snip_exec."},
  {NULL, NULL, 0, NULL}
};


PyMODINIT_FUNC
initsenna(void)
{
  PyObject *m;

  m = Py_InitModule("senna", SennaMethods);
  SennaError = PyErr_NewException("senna.error", NULL, NULL);
  Py_INCREF(SennaError);
  PyModule_AddObject(m, "error", SennaError);
  PyModule_AddIntConstant(m, "SEN_INDEX_NORMALIZE", 0x0001);
  PyModule_AddIntConstant(m, "SEN_INDEX_SPLIT_ALPHA", 0x0002);
  PyModule_AddIntConstant(m, "SEN_INDEX_SPLIT_DIGIT", 0x0004);
  PyModule_AddIntConstant(m, "SEN_INDEX_SPLIT_SYMBOL", 0x0008);
  PyModule_AddIntConstant(m, "SEN_INDEX_MORPH_ANALYSE", 0x0000);
  PyModule_AddIntConstant(m, "SEN_INDEX_NGRAM", 0x0010);
  PyModule_AddIntConstant(m, "SEN_INDEX_DELIMITED", 0x0020);
  PyModule_AddIntConstant(m, "SEN_INDEX_ENABLE_SUFFIX_SEARCH", 0x0100);
  PyModule_AddIntConstant(m, "SEN_INDEX_DISABLE_SUFFIX_SEARCH", 0x0200);
  PyModule_AddIntConstant(m, "SEN_INDEX_WITH_VACUUM", 0x8000);
  PyModule_AddIntConstant(m, "sen_enc_default", sen_enc_default);
  PyModule_AddIntConstant(m, "sen_enc_none", sen_enc_none);  
  PyModule_AddIntConstant(m, "sen_enc_euc_jp", sen_enc_euc_jp);
  PyModule_AddIntConstant(m, "sen_enc_utf8", sen_enc_utf8);
  PyModule_AddIntConstant(m, "sen_enc_sjis", sen_enc_sjis);
  PyModule_AddIntConstant(m, "SEN_SNIP_NORMALIZE", SEN_SNIP_NORMALIZE);
}
