#include "snippet_api.h"


static char *defaultopentag = "";
static char *defaultclosetag = "";
static unsigned int max_tagged_len = 0;


PyObject *
senna_sen_snip_open(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_encoding encoding = sen_enc_default;
  int flags = SEN_SNIP_NORMALIZE;
  size_t width = 0;
  unsigned int max_results = 0;
  unsigned int defaultopentag_len = 0;
  unsigned int defaultclosetag_len = 0;
  sen_snip_mapping *mapping = NULL;
  sen_snip *snip;
  PyObject *snip_obj;
  
  static char *kwlist[] = {"encoding", "flags", "width", "max_results",
			   "defaultopentag", "defaultclosetag", "mapping", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, keywds, "iIiI|s#s#i", kwlist,
                                   &encoding, &flags, &width, &max_results,
				   &defaultopentag, &defaultopentag_len,
				   &defaultclosetag, &defaultclosetag_len, &mapping)) {
    return NULL;
  }
  snip = sen_snip_open(encoding, flags, width, max_results,
		       defaultopentag, defaultopentag_len,
		       defaultclosetag, defaultclosetag_len, mapping);
  snip_obj = PyCObject_FromVoidPtr((void*)snip, NULL);
  return Py_BuildValue("O", snip_obj);
}


PyObject *
senna_sen_snip_close(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  PyObject * snip_obj = NULL;
  sen_snip * snip = NULL;
  static char *kwlist[] = {"snip", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &snip_obj)) {
    return NULL;
  }
  snip = (sen_snip*)PyCObject_AsVoidPtr(snip_obj);
  rc = sen_snip_close(snip);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_snip_add_cond(PyObject *self, PyObject *args, PyObject *keywds)
{
  PyObject *snip_obj;
  sen_snip *snip;
  char *keyword = "";
  char *opentag = NULL;
  char *closetag= NULL;
  unsigned int keyword_len = 0;
  unsigned int opentag_len = 0;
  unsigned int closetag_len = 0;
  sen_rc rc;

  static char *kwlist[] = {"snip", "keyword", "opentag", "closetag", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, keywds, "Os#|s#s#", kwlist,
				   &snip_obj, &keyword, &keyword_len,
				   &opentag, &opentag_len,
				   &closetag, &closetag_len)) {
    return NULL;
  }
  snip = (sen_snip*)PyCObject_AsVoidPtr(snip_obj);
  rc = sen_snip_add_cond(snip, keyword, keyword_len,
                         opentag, opentag_len,
                         closetag, closetag_len);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_snip_exec(PyObject *self, PyObject *args, PyObject *keywds)
{
  PyObject *snip_obj;
  sen_snip *snip;
  char *string = "";
  unsigned int string_len = 0;
  unsigned int nresults = 0;
  sen_rc rc;

  static char *kwlist[] = {"snip", "string", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, keywds, "Os#", kwlist,
				   &snip_obj, &string, &string_len)) {
    return NULL;
  }
  snip = (sen_snip*)PyCObject_AsVoidPtr(snip_obj);
  rc = sen_snip_exec(snip, string, string_len, &nresults, &max_tagged_len);
  return Py_BuildValue("i", nresults);
}


PyObject *
senna_sen_snip_get_result(PyObject *self, PyObject *args, PyObject *keywds)
{
  PyObject *snip_obj;
  sen_snip *snip;
  unsigned int index = 0;
  char *result = NULL;
  unsigned int result_len = 0;
  sen_rc rc;

  static char *kwlist[] = {"snip", "index", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O|I", kwlist,
				   &snip_obj, &index)) {
    return NULL;
  }
  snip = (sen_snip*)PyCObject_AsVoidPtr(snip_obj);
  result = (char*)malloc(max_tagged_len);
  rc = sen_snip_get_result(snip, index, result, &result_len);
  return Py_BuildValue("s#", result, result_len);
}
