# -*- coding: utf-8 -*-

import senna


path1 = '/tmp/pysenna_testindex'
path2 = '/tmp/pysenna_testindex_renamed'


ret = senna.sen_init()
print 'sen_init: %d' % ret

ret = senna.sen_index_remove(path1)
print 'sen_index_remove("%s"): %d' % (path1, ret)
ret = senna.sen_index_remove(path2)
print 'sen_index_remove("%s"): %d' % (path2, ret)

ret = senna.sen_index_create(path=path1,
                             encoding=senna.sen_enc_utf8)
print 'sen_index_create: ' + str(ret)

ret = senna.sen_index_rename(old_name=path1, new_name=path2)
print 'sen_index_rename: %d' % ret

index = senna.sen_index_open(path2)
print 'sen_index_open("%s"): ' % path2 + str(index)

ret = senna.sen_index_upd(index, 'key1', '', u'こんにちは'.encode('utf-8'))
print 'sen_index_upd: %d' % ret
ret = senna.sen_index_upd(index, 'key2', '', u'さようなら'.encode('utf-8'))
print 'sen_index_upd: %d' % ret
ret = senna.sen_index_upd(index, 'key3', '', u'ふたたびこんにちは'.encode('utf-8'))
print 'sen_index_upd: %d' % ret

rec = senna.sen_index_sel(index, u'こんにちは'.encode('utf-8'))
while senna.sen_records_next(rec) != 0:
    print ', '.join(('key: ' + senna.sen_records_curr_key(rec),
                     'score: ' + str(senna.sen_records_curr_score(rec))))
ret = senna.sen_records_close(rec)
print 'sen_records_close: %d' % ret

ret = senna.sen_index_close(index)
print 'sen_index_close: %d' % ret

ret = senna.sen_index_remove(path2)
print 'sen_index_remove: %d' % ret

ret = senna.sen_fin()
print 'sen_index_fin: %d' % ret

#sym = senna.sen_sym_open(path2 + '.SEN.l')
#print senna.sen_sym_info(sym)
#print senna.sen_sym_size(sym)
