# -*- encoding: utf-8 -*-

import senna

text = u"""APIは、basic API, advanced API, low-level API, toolkit APIの4種類から構成されます。
basic APIを使ってインデックスの作成・更新・検索の一通りの機能を使用できます。
advanced APIを用いることによって、検索精度の細かなチューニングを制御することが可能になります。
low-level APIを用いることによってSennaの内部のデータ構造にアクセスし、
さらに複雑なデータの操作や検索処理が行えます。
toolkit APIはさまざまな便利な機能を提供します。"""

snip = senna.sen_snip_open(encoding=senna.sen_enc_utf8,
                           flags=senna.SEN_SNIP_NORMALIZE,
                           width=60,
                           max_results=3,
                           defaultopentag='<b>',
                           defaultclosetag='</b>'
                           )

print senna.sen_snip_add_cond(snip=snip,
                              keyword='basic API',
                              opentag='<em>',
                              closetag='</em>')

num_results = senna.sen_snip_exec(snip=snip, string=text.encode('utf-8'))
print num_results

for i in range(num_results):
    print senna.sen_snip_get_result(snip=snip, index=i)

print senna.sen_snip_close(snip)
