######################################################################
# clipcopy.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: clipcopy.pl,v 1.21 2006/03/06 00:51:13 papu Exp $
#
# "clipcopy plugin" version 1.0 $$
# Author: Nanami http://lineage.netgamers.jp/
# Copyright (C) 2004-2006 by Nekyo.
# http://nekyo.hp.infoseek.co.jp/
# Copyright (C) 2005-2006 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=EUC 1TAB=4Spaces
######################################################################
# clipcopy ץ饰
# IEѤΥץ饰ǡåƥ硼ȥåȤ򥳥ԡΤ
# 󥯥åǤǤ褦ˤΤǤ
# IEʳǤϡϤޤ
#
# usage : &clipcopy(url, text);
######################################################################

use strict;
package clipcopy;

sub plugin_inline {
	my ($arg)=@_;
	my ($linkurl,$text,$copiedtext)=split(/,/,$arg);

	my $body;

	$text=&javascriptspecialchars($text);
	$linkurl=&javascriptspecialchars($linkurl);

	if($ENV{HTTP_USER_AGENT}=~/MSIE/ && $ENV{HTTP_USER_AGENT}!~/Opera/) {
#		return " " if($linkurl!~/$::isurl/);
		if($copiedtext eq '') {
			$copiedtext="$linkurl copied to clipboard";
		} else {
			$copiedtext=&javascriptspecialchars($copiedtext);
		}
		$body=<<EOM;
(<a href="javascript:void(0);" title="$linkurl" onclick="clipboardData.setData('Text', '$linkurl');alert('$copiedtext')">$text</a>)
EOM
		return $body;
	}
	return " ";
}

sub javascriptspecialchars {
	my ($s) = @_;
	$s =~ s|\r\n|\n|g;
	$s =~ s|\&|&amp;|g;
	$s =~ s|<|&lt;|g;
	$s =~ s|>|&gt;|g if($s=~/</);
	$s =~ s|"|&quot;|g;
	$s =~ s|'|&apos;|g;
	return $s;
}

sub plugin_clipcopy_pyukiver {
	my ($v,$s)=split(/\-/,$::version);
	$v=~s/\.//g;
	return 1 if($v+0>=16);
	return 0;
}

1;
__END__

=head1 NAME

clipcopy.pl - PyukiWiki / YukiWiki Plugin

=head1 SYNOPSIS

 &clipcopy(linkurl, text, [copiedtext]);
 &clipcopy(http://pyukiwiki.sourceforge.jp?rss
  ,RSS Link Copy,http://pyukiwiki.sourceforge.jp?rss Copied to clipboard);

=head1 DESCRIPTION

Specified URL is copied to a clipboard. Any character strings other than URL cannot be specified.

Only Internet Explorer.
Nothing is returned in the other browser.

This plugin is compatible with YukiWiki.

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/clipcopy

L<http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/Nanami/clipcopy/>

=item PyukiWiki CVS

L<http://cvs.sourceforge.jp/cgi-bin/viewcvs.cgi/pyukiwiki/PyukiWiki-Devel/plugin/clipcopy.pl>

=back

=head1 AUTHOR

=over 4

=item Nekyo

L<http://nekyo.hp.infoseek.co.jp/>

=item PyukiWiki Developers Team

L<http://pyukiwiki.sourceforge.jp/>

=back

=head1 LICENSE

Copyright (C) 2004-2006 by Nekyo.

Copyright (C) 2005-2006 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 2 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
