######################################################################
# Lock.pm - This is PyukiWiki, yet another Wiki clone.
# $Id$
#
# "Nana::Lock" version 0.2 $$
# Author: Nanami
# http://nanakochi.daiba.cx/
# Copyright (C) 2004-2010 by Nekyo.
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2010 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=Shift-JIS 1TAB=4Spaces
######################################################################
#
# 莁renamet@CbNɑ΂āAȉ̉Ǔ_܂B
# EfBNggȂ
#   S̃bNł͂ȂAet@CŃbN
#
# YukiWikiDBAȉ̉Ǔ_܂B
# Elock֌Wʉł悤ɁAt@Cǂݏ̃t@C
#
# from http://www.din.or.jp/~ohzaki/perl.htm#File_Lock
#
######################################################################

package	Nana::Lock;
use 5.005;
use strict;
use vars qw($VERSION);
$VERSION = '0.2';

$Nana::Lock::DEBUG=0;						# debug
# PɂƃbN֌W̃bZ[Wł܂# debug
# error										# debug
sub die {									# debug
	$::debug.="Nana::Lock:Error:$_[0]\n";	# debug
	return undef;							# debug
}											# debug
# message									# debug
sub msg {									# debug
	$::debug.="Nana:Lock:$_[0]\n"			# debug
		if($Nana::Lock::DEBUG eq 1);		# debug
}											# debug

$Nana::Lock::LOCK_SH=1;
$Nana::Lock::LOCK_EX=2;
$Nana::Lock::LOCK_NB=4;
$Nana::Lock::LOCK_DELETE=128;

# rename lock idea
# http://www.din.or.jp/~ohzaki/perl.htm#File_Lock
# bNt@Č`															# debug
# (t@Cŕsv).(method).(pid).(time).lk					# debug
#       0 : bNȂBȗ̃ftHg									# debug
#       1 : (LOCK_SH) LbNCgC									# debug
#       2 : (LOCK_EX) rbNCgC									# debug
#       5 : (LOCK_SH|LOCK_NB) LbNCgCȂ							# debug
#       6 : (LOCK_EX|LOCK_NB) rbNCgCȂ							# debug
#       8 : (LOCK_UN) gȂƁB											# debug
#     128 : (LOCK_DELETE) bNt@C̍폜									# debug

sub lock {
	my $timeout=5;
	my $trytime=2;

	my($fname,$method)=@_;
	# fBNgAt@CAgq𕪗									# debug
	my($d,$f,$e)=$fname=~/(.*)\/(.+)\.(.+)$/;
	# t@CL炵̂(Z邽)							# debug
	$f=~s/[.%()[]:*,_]//g;
	# nh̍쐬														# debug
	my %lfh=(
		dir=>$d,
		basename=>$f,
		timeout=>$timeout,
		trytime=>($method & $Nana::Lock::LOCK_NB ? 0 : $trytime),
		fname=>$fname,
		method=>$method & 3,
		path=>"$d/$f.lk"
	);
	# bNt@C̍폜									# debug
	if($method eq $Nana::Lock::LOCK_DELETE) {
		return &lock_del(%lfh);
	}
	# methodꍇreturn							# debug
	if($lfh{method} eq 0) {									# debug
		&msg("lock error:$fname $lfh{method} - $method");	# debug
		return;												# debug
	}														# debug
	return if($lfh{method} eq 0);

	for(my $i=0; $i < $lfh{trytime}*10; $i++) {
		# bN\bhAvZXIDAݎ										# debug
		$lfh{current}=sprintf("%s/%s.%x.%x.%x.%d.lk"
			,$lfh{dir},$lfh{basename},$lfh{method},$$,time);
		# bNA͐I															# debug
		if(rename($lfh{path},$lfh{current})) {												# debug
			&msg(sprintf("%s:%s->%s"														# debug
				,($lfh{method} eq 1 ? 'LOCK_SH' : 'LOCK_EX'), $lfh{path},$lfh{current}));	# debug
			return \%lfh;																	# debug
		}																					# debug
		return \%lfh if(rename($lfh{path},$lfh{current}));

		# ߋ̃bNt@C														# debug
		my @filelist=&lock_getdir(%lfh);
		my @locklist=();
		my $fcount=0;
		my $excount=0;
		my $shcount=0;
		foreach (@filelist) {
			if (/^$lfh{basename}\.(\d)\.(.+)\.(.+)\.lk$/) {
				push(@locklist,"$1\t$2\t$3");
				$fcount++;
				$shcount++ if($1 eq 1);
				$excount++ if($1 eq 2);
				&msg(sprintf("Found:%s.%s.%s.%s.lk(method=%d,all=%d,ex=%d,sh=%d)"			# debug
					,$lfh{basename},$1,$2,$3,$lfh{method},$fcount,$excount,$shcount));		# debug
			}
		}
		# bNt@C݂ȂΐVK쐬											# debug
		if($fcount eq 0) {
			&msg("Create $lfh{path}");														# debug
			open(LFHF,">$lfh{path}");# or return undef;
			close(LFHF);
			next;
		# LbN̏ꍇ																	# debug
		} elsif($lfh{method} eq 1) {
			# r݂Ȃꍇ															# debug
			&msg("SH Lock Check $lfh{basename}");											# debug
			if($shcount > 0 && $excount eq 0) {
				# P`CXāAl[											# debug
				foreach(@locklist) {
					my($method,$pid,$time)=split(/\t/,$_);
					my $orgf=sprintf("%s/%s.%x.%s.%s.lk"
						,$lfh{dir},$lfh{basename},$method,$pid,$time);
					&msg("new fn=$orgf");													# debug
					# ăbN																# debug
					if(rename($orgf,$lfh{current})) {										# debug
						&msg(sprintf("%s:%s->%s"											# debug
							,"LOCK_SH",$orgf,$lfh{current}));								# debug
						return \%lfh;														# debug
					}																		# debug
					return \%lfh if(rename($orgf,$lfh{current}));
				}
			}
		}
		# rłorُ펞																# debug
		# 0.1bsleepAgȂ1b														# debug
		eval("select undef, undef, undef, 0.1;");
		if($@) {
			sleep 1;
			$i+=9;
			&msg("waiting 1sec count $i");													# debug
		} else {																			# debug
			&msg("waiting 0.1sec count $i");												# debug
		}
	}
	# ĎsI																			# debug
	# ߋ̃bNt@C															# debug
	my @filelist=&lock_getdir(%lfh);
	foreach (@filelist) {
		if (/^$lfh{basename}\.(\d)\.(.+)\.(.+)\.lk$/) {
			# ^CAEgĂ݂̂											# debug
			if (time - hex($3) > $lfh{timeout}) {
				my $orgf=sprintf("%s/%s.%s.%s.%s.lk"
					,$lfh{dir},$lfh{basename},$1,$2,$3);
				if(rename($orgf,$lfh{current})) {											# debug
					&msg(sprintf("%s:%s->%s"												# debug
						,"FORCE_LOCK",$orgf,$lfh{current}));								# debug
					return \%lfh;															# debug
				}																			# debug
				return \%lfh if(rename($orgf,$lfh{current}));
			}
		}
	}
	&msg("lock:can't lock");																# debug
	return undef;
}

sub unlock {
	if(rename($_[0]->{current}, $_[0]->{path})) {											# debug
		&msg("LOCK_UN" . $_[0]->{current} . "->" . $_[0]->{path});							# debug
	}																						# debug
	rename($_[0]->{current}, $_[0]->{path});
}

sub lock_del {
	my(%lfh)=@_;
	unlink($lfh{path});
	&msg("LOCK_DELETE: $lfh{path}");							# debug
	my @filelist=&lock_getdir(%lfh);
	foreach (@filelist) {
		if (/^$lfh{basename}\.(\d)\.(.+)\.(.+)\.lk$/) {
			unlink($_);
			&msg("LOCK_DELETE: $_");							# debug
		}
	}
}

sub lock_getdir {
	my(%lfh)=@_;
	opendir(LOCKDIR, $lfh{dir});
	my @filelist = readdir(LOCKDIR);
	closedir(LOCKDIR);
	return @filelist;
}

1;
__END__
