######################################################################
# authadmin_cookie.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: authadmin_cookie.inc.pl,v 1.244 2011/10/19 22:07:02 papu Exp $
#
# "PyukiWiki" version 0.2.0-alpha16 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2011 by Nekyo.
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2011 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=EUC-JP 1TAB=4Spaces
######################################################################
# This is extented plugin.
# To use this plugin, rename to 'authadmin_cookie.inc.cgi'
######################################################################
#
# ѥɤΰcookie¸
#
# ¸ʤcookieȤơ֥饦Υåͭʴ֤
# ѥɤ¸ޤС֥饦Ĥޤ
# ѥɤ¸ޤ
#
######################################################################

$::authadmin_cookie_pass="PAP";
$::authadmin_cookie_enc="PAE";
$::authadmin_cookie_token="PAT";

# Initlize										# comment

sub plugin_authadmin_cookie_init {
	# force init lang.inc.cgi
	&exec_explugin_sub("lang");

	my %passwdcookie;
	my %passwdenccookie;
	my %passwdtokencookie;
	%passwdcookie=&getcookie($::authadmin_cookie_pass,%passwdcookie);
	%passwdenccookie=&getcookie($::authadmin_cookie_enc,%passwdenccookie);
	%passwdtokencookie=&getcookie($::authadmin_cookie_token,%passwdtokencookie);
	my $nocookie=0;
	foreach("attach", "frozen", "admin") {
		next if($passwdcookie{$_} eq '' || $passwdenccookie{$_} eq '' && $passwdtokencooki{$_} eq '');
		$nocookie=1;
		return ('header'=>$header,'init'=>1
			, 'func'=>'authadminpassword', 'authadminpassword'=>\&authadminpassword);
	}

	if(&valid_password($passwdcookie{"admin"},"admin"
		, $passwdenccookie{"admin"}, $passwdtokencookie{"admin"})) {
		if($::navi{"admin_url"} eq '') {
			push(@::addnavi,"admin:help");
			$::navi{"admin_url"}="$::script?cmd=admin";
			$::navi{"admin_name"}=$::resource{"adminbutton"};
			$::navi{"admin_type"}="plugin";
		}
	}

	if(&iscryptpass) {
		foreach("attach", "frozen", "admin") {
			if($passwdenccookie{$_} ne '') {
				$passwdenccookie{$_}=&password_encode(&password_decode('',$passwdenccookie{$_},$passwdtokencookie{$_}), $::Token);
				$passwdtokencookie{$_}=$::Token;
			}
		}
		&setcookie($::authadmin_cookie_pass,-1,%passwdcookie);
		&setcookie($::authadmin_cookie_enc,0,%passwdenccookie);
		&setcookie($::authadmin_cookie_token,0,%passwdtokencookie);
	}

	return ('header'=>$header,'init'=>1
		, 'func'=>'authadminpassword', 'authadminpassword'=>\&authadminpassword);
}

sub authadminpassword {
	my($mode,$title,$type)=@_;
	my $body;
	my $auth=0;
	$type=($type eq "attach" ? "attach" : $type eq "frozen" ? "frozen" : "admin");
	my $cookie=$type;
	$cookie="admin" if($::adminpass{admin} eq '' && $::adminpass{frozen} eq '' && $::adminpass{attach} eq '');

	my %passwdcookie;
	my %passwdenccokie;
	my %passwdtokencookie;

	%passwdcookie=&getcookie($::authadmin_cookie_pass,%passwdcookie);
	%passwdenccookie=&getcookie($::authadmin_cookie_enc,%passwdenccookie);
	%passwdtokencookie=&getcookie($::authadmin_cookie_token,%passwdtokencookie);
	if($::form{mypassword} eq '' && $::form{mypassword_enc} eq ''
	 && $::form{mypassword_token} eq '' && (
			   &valid_password($passwdcookie{$cookie},$cookie
				, $passwdenccookie{$cookie}, $passwdtokencookie{$cookie})
			|| &valid_password($passwdcookie{"admin"},"admin"
				, $passwdenccookie{"admin"}, $passwdtokencookie{"admin"})
			|| &valid_password($passwdcookie{"attach"},"admin"
				, $passwdenccookie{"admin"}, $passwdtokencookie{"admin"})
			|| &valid_password($passwdcookie{"frozen"},"admin"
				, $passwdenccookie{"admin"}, $passwdtokencookie{"admin"})
			)) {
		$::form{"mypassword_$type"}=$passwdcookie{$cookie};
		$::form{"mypassword_$type\_enc"}=$passwdenccookie{$cookie};
		$::form{"mypassword_$type\_token"}=$passwdtokencookie{$cookie};
		$auth=1;
	} elsif(&valid_password($::form{"mypassword_$type"},$type
		, $::form{"mypassword_$type\_enc"}, $::form{"mypassword_$type\_token"})
		 || &valid_password($::form{"mypassword_$type"},"admin"
		, $::form{"mypassword_$type\_enc"}, $::form{"mypassword_$type\_token"})) {
		$passwdcookie{$cookie}=$::form{"mypassword_$type"};
		$passwdenccookie{$cookie}=$::form{"mypassword_$type\_enc"};
		$passwdtokencookie{$cookie}=$::form{"mypassword_$type\_token"};

		if(&iscryptpass) {
			&setcookie($::authadmin_cookie_pass,-1,%passwdcookie);
			&setcookie($::authadmin_cookie_enc,0,%passwdenccookie);
			&setcookie($::authadmin_cookie_token,0,%passwdtokencookie);
		} else {
			&setcookie($::authadmin_cookie_pass,0,%passwdcookie);
			&setcookie($::authadmin_cookie_enc,-1,%passwdenccookie);
			&setcookie($::authadmin_cookie_token,-1,%passwdtokencookie);
		}
		$auth=1;
	}

	if($mode=~/submit|page|form/) {
		$title=$::resource{admin_passwd_prompt_title} if($title eq '');
		if(!$auth) {
			$body=<<EOM;
<h2>$title</h2>
@{[$ENV{REQUEST_METHOD} eq 'GET' && $::form{mypassword} eq '' ? '' : qq(<div class="error">$::resource{admin_passwd_prompt_error}</div>\n)]}
<form action="$::script" method="post" id="adminpasswordform" name="adminpasswordform">
$::resource{admin_passwd_prompt_msg}@{[&passwordform('','',"mypassword_$type")]}
EOM
			if(&iscryptpass) {
				$body.=<<EOM;
<span id="submitbutton"></span>
<script type="text/javascript"><!--
	getid("submitbutton").innerHTML='<input type="button" value="$::resource{admin_passwd_button}" onclick="fsubmit(\\'adminpasswordform\\',\\'$type\\');" onkeypress="fsubmit(\\'adminpasswordform\\',\\'$type\\',event);" />';
//--></script>
<noscript><input type="submit" value="$::resource{admin_passwd_button}" /></noscript>
EOM
			} else {
				$body.=<<EOM;
<input type="submit" value="$::resource{admin_passwd_button}" />
EOM
			}
			foreach my $forms(keys %::form) {
				$body.=qq(<input type="hidden" name="$forms" value="$::form{$forms}" />\n)
					if($forms!~/^mypassword/);
			}
			$body.="</form>\n";
			return('authed'=>0,'html'=>$body, 'crypt'=>&iscryptpass);
		} else {
			$body.=qq(@{[&passwordform($::form{"mypassword\_$type"},"hidden","mypassword\_$type",$::form{"mypassword\_$type\_enc"},$::form{"mypassword\_$type\_token"})]}\n);
			return('authed'=>1,'html'=>$body, 'crypt'=>&iscryptpass);
		}
	} else {
		if(!$auth) {
			$body.=<<EOM;
@{[$ENV{REQUEST_METHOD} eq 'GET' && $::form{mypassword} eq '' ? '' : qq(<div class="error">$::resource{admin_passwd_prompt_error}</div>)]}
EOM
			$body.=qq(@{[$title ne '' ? $title : $::resource{admin_passwd_prompt_msg}]}@{[&passwordform('','',"mypassword_$type")]}\n);
			return('authed'=>0,'html'=>$body, 'crypt'=>&iscryptpass);
		} else {
			$body.=qq(@{[&passwordform($::form{"mypassword\_$type"},"hidden","mypassword\_$type",$::form{"mypassword\_$type\_enc"},$::form{"mypassword\_$type\_token"})]}\n);
			return('authed'=>1,'html'=>$body, 'crypt'=>&iscryptpass);
		}
	}
}

1;
__DATA__
sub plugin_authadmin_cookie_setup {
	return(
	'en'=>'Frozen password saved on temporary cookie',
	'jp'=>'ѥɤå¸',
	'override'=>'authadminpassword',
	'url'=>'http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/ExPlugin/authadmin_cookie/'
	);
__END__
=head1 NAME

authadmin_cookie.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

Frozen password saved on temporary cookie

=head1 USAGE

rename to authadmin_cookie.inc.cgi

=head1 OVERRIDE

authadminpassword function was overrided.

=BUGS

This plugin is evaluation version. In 1.0, the mounting method is be changed.

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/ExPlugin/authadmin_cookie

L<http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/ExPlugin/authadmin_cookie/>

=item PyukiWiki CVS

L<http://sourceforge.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/lib/authadmin_cookie.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sourceforge.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2011 by Nanami.

Copyright (C) 2005-2011 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 2 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
