######################################################################
# bookmark.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: bookmark.inc.pl,v 1.238 2012/01/30 15:16:27 papu Exp $
#
# "bookmark" version 1.3 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2012 Nekyo
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.sfjp.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=EUC-JP 1TAB=4Spaces
######################################################################

$PLUGIN="bookmark";
$VERSION="1.3";

use strict;
my $body;

my $js_bookmark=<<EOM;
<script type="text/javascript"><!--
function setbookmark(a,b){a=decodeURIComponent(a);b=decodeURIComponent(b);if(d.all){window.external.AddFavorite(a,b)}else{if(navigator.userAgent.indexOf("Firefox")!=-1){window.sidebar.addPanel(b,a,"")}}};
//--></script>
EOM

my $js_reghome=<<EOM;
<script type="text/javascript"><!--
function sethomepage(u,t){
function sethomepage(a,c){a=decodeURIComponent(a);c=decodeURIComponent(c);var b=navigator.userAgent;var g=b.indexOf("MSIE");var f=parseInt(b.substring(g+5,g+6,g+7,g+8,g+9));var e=b.indexOf("Windows");if(d.all){if(g>0&&f>=5&&e>0){d.body.style.behavior="url('#default#homepage')";d.body.setHomePage(a)}else{window.external.AddFavorite(a,c)}}};
//--></script>
EOM

sub plugin_bookmark_convert {
	return &plugin_bookmark_inline(@_);
}

sub plugin_bookmark_inline {
	my ($arg)=@_;
	my ($title,$url,$pagename,$mode,$title2)=split(/,/,$arg);
#	my $body;

	my $agent=$ENV{HTTP_USER_AGENT};
	return ' 'unless($agent=~/MSIE/ && $agent!~/Opera/ || $agent=~/FireFox/);

	my $iever;
	if($agent=~/MSIE\s(.*?);/) {
		$iever=$1 + 0;
	}
	return if($url ne &javascriptspecialchars($url));
	$pagename=&javascriptspecialchars($pagename);

	if(&plugin_bookmark_pyukiver) {
		$url=$::basehref if($url eq '');
	} else {
		$url=&getbasehref if($url eq '');
	}
	if($pagename eq '') {
		if($::wiki_title ne '') {
			$pagename=$::wiki_title;
		} else {
			$pagename=$::form{mypage};
		}
	}
	if($url!~/^http/ && $title eq '') {
		$body=<<EOM;
<br>
<strong>bookmark plugin</strong><br>
Usage: #bookmark(text,[url],[pagename],[start]);<br>
EOM
	} else {
		if($mode=~/([Hh][Oo][Mm][Ee])|([Ss][Tt][Aa][Rr][Tt])/
			&& $agent=~/Windows/ && $iever>=5) {
			my $urltmp=&escape(&code_convert(\$url,'utf8',$::defaultcode));
			my $pagetmp=&escape(&code_convert(\$pagename,'utf8',$::defaultcode))			$body=<<EOM;
<a href="javascript:void(0);" onclick="sethomepage('$urltmp','$pagetmp');">$title</a>
EOM
			$::IN_HEAD.=$js_reghome if($::IN_HEAD!~/function\ sethomepage/);
		} else {
			$title=$title2
				if($iever<5 && $mode=~/([Hh][Oo][Mm][Ee])|([Ss][Tt][Aa][Rr][Tt])/
					&& $title2 ne '');
			my $urltmp=&escape(&code_convert(\$url,'utf8',$::defaultcode));
			my $pagetmp=&escape(&code_convert(\$pagename,'utf8',$::defaultcode));

			$body=<<EOM;
<a href="javascript:void(0);" onclick="setbookmark('$urltmp','$pagetmp');">$title</a>
EOM
			$::IN_HEAD.=$js_bookmark if($::IN_HEAD!~/function\ setbookmark/);

		}
	}
	return $body if(&plugin_bookmark_pyukiver);
	if($::IN_HEAD=~/function\ set(homepage|bookmark)/) {
		$body=$::IN_HEAD . $body;
		$::IN_HEAD="<!-- function sethomepage, function setbookmark -->";
	}
	return $body;
}

sub javascriptspecialchars {
	my ($s) = @_;
	$s =~ s|\r\n|\n|g;
	$s =~ s|\&|&amp;|g;
	$s =~ s|<|&lt;|g;
	$s =~ s|>|&gt;|g if($s=~/</);
	$s =~ s|"|&quot;|g;
	$s =~ s|'|&apos;|g;
	return $s;
}

sub plugin_bookmark_pyukiver {
	my ($v,$s)=split(/\-/,$::version);
	$v=~s/\.//g;
	return 1 if($v+0>=16);
	return 0;
}

sub getbasehref {
	# Thanks moriyoshi koizumi.
	my $basehref = "$ENV{'HTTP_HOST'}";
	if (($ENV{'https'} =~ /on/i) || ($ENV{'SERVER_PORT'} eq '443')) {
		$basehref = 'https://' . $basehref;
	} else {
		$basehref = 'http://' . $basehref;
		$basehref .= ":$ENV{'SERVER_PORT'}" if ($ENV{'SERVER_PORT'} ne '80');
	}
	$basehref .= $ENV{'SCRIPT_NAME'};
}

1;
__END__

=head1 NAME

bookmark.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 &bookmark(Bookmark This Page);
 &bookmark(Regist Start Page,http://pyukiwiki.sfjp.jp/,start,Bookmark This Page);

=head1 DESCRIPTION

Make Bookmark link for Windows Internet Explorer

=head1 USAGE

 &bookmark(text, [url], [page name], [start], [substitution text]);

=over 4

=item text (Indispensable)

It writes hear, link text.

=item url

Link to url

When omits, $::basehref url is displayed.

=item page name

Bookmark to page title.

When omits, $::wiki_title value or FrontPage title is displayed.

=item start

Create link for registering start page.

The link automatically registered into a bookmark is created to the browser which cannot be registered into a start page.

=item substitution text

It is an alternative text for registering with the bookmark to the browser which cannot be registered into a start page.

=back

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/bookmark

L<http://pyukiwiki.sfjp.jp/PyukiWiki/Plugin/Nanami/bookmark/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/bookmark.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/bookmark.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sfjp.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2012 by Nanami.

Copyright (C) 2005-2012 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
