######################################################################
# wiki_func.cgi - This is PyukiWiki, yet another Wiki clone.
# $Id: wiki_func.cgi,v 1.53 2012/08/16 01:24:27 papu Exp $
# Build on 2012-08-16 02:02:00
#
# "PyukiWiki" ver 0.2.1-beta1 $$
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=Shift-JIS 1TAB=4Spaces
######################################################################

	# SGML̊當̃GXP[vR[h̎̎QƂ̐K\		# comment
$::_sgmlescape=q{aelig|aacute|acirc|agrave|aring|atilde|auml|ccedil|eth|eacute|ecirc|egrave|euml|iacute|icirc|igrave|iuml|ntilde|oacute|ocirc|ograve|oslash|otilde|oumltimes|thorn|uacute|ucirc|ugrave|uuml|yacute|acute|amp|bdquo|big|big_plus|bigsmile|brvbar|bull|cedil|cent|copy|curren|dagger|deg|divide|euro|frac12|frac14|frac34|heart|heart2|heartplus|huh|iexcl|iquest|laquo|ldquo|lsquo|macr|mdash|micro|middot|nbsp|ndash|not|oh|oh2|ohplus|ordf|ordm|ouml|para|permil|plusmn|pound|raquo|rdquo|reg|rsquo|sad|sad2|sadplus|sbquo|sect|shy|smile|smile2|smileplus|star|sup1|sup2|sup3|szlig|tear|trade|uml|ummr|wink|wink2|winkplus|worried|worried2|worriedplus|yen|yuml};

	# HTMLGXP[ṽe[u									# comment
%::_htmlspecial = (
	'&' => '&amp;',
	'<' => '&lt;',
	'>' => '&gt;',
	'"' => '&quot;',
);

	# HTMLAGXP[ṽe[u								# comment
%::_unescape = (
	'amp'  => '&',
	'lt'   => '<',
	'gt'   => '>',
	'quot' => '"',
);

=head1 NAME

wiki_func.cgi - This is PyukiWiki, yet another Wiki clone.

=head1 DESCRIPTION

PyukiWiki is yet another Wiki clone. Based on YukiWiki

PyukiWiki can treat Japanese WikiNames (enclosed with [[ and ]]).
PyukiWiki provides 'InterWiki' feature, RDF Site Summary (RSS),
and some embedded commands (such as [[# comment]] to add comments).

=head1 SEE ALSO

=over 4

=item PyukiWiki/Dev/Specification/wiki_func.cgi

L<http://pyukiwiki.info/PyukiWiki/Dev/Specification/wiki_func.cgi/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/lib/wiki_func.cgi?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/lib/wiki_func.cgi?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/lib/wiki_func.cgi?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/lib/wiki_func.cgi?view=log>

=back

=head1 AUTHOR

=over 4

=item Nekyo

L<>

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright (C) 2004-2007 by Nekyo.

Copyright (C) 2005-2012 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

=lang ja

=head2 getbasehref

=over 4

=item ͒l

Ȃ

=item o

$::basehref, $::basepath, $::script

=item I[o[Ch



=item Tv

ƂȂURL쐬BO $::basehrefy $::basepathݒ肳Ăꍇ
ȂB

=back

=cut

sub _getbasehref {
	# Thanks moriyoshi koizumi.
	return if($::basehref ne '');
	$::basehost = "$ENV{'HTTP_HOST'}";

	# SSL̏ꍇ									# comment
	if (($ENV{'https'} =~ /on/i) || ($ENV{'SERVER_PORT'} eq '443')) {
		$::basehost = 'https://' . $::basehost;
	# http̏ꍇ								# comment
	} else {
		$::basehost = 'http://' . $::basehost;
		# Special Thanks to gyo					# comment
		$::basehost .= ":$ENV{'SERVER_PORT'}"
			if ($ENV{'SERVER_PORT'} ne '80' && $::basehost !~ /:\d/);
	}

	# URL̐									# comment
	my $uri;
	my $req=$ENV{REQUEST_URI};
	$req=~s/\?.*//g;
	if($req ne '') {
		if($req eq $ENV{SCRIPT_NAME}) {
			$uri= $ENV{'SCRIPT_NAME'};
		} else {
			for(my $i=0; $i<length($ENV{SCRIPT_NAME}); $i++) {
				if(substr($ENV{SCRIPT_NAME},$i,1) eq substr($req,$i,1)) {
					$uri.=substr($ENV{SCRIPT_NAME},$i,1);
				} else {
					last;
				}
			}
		}
	} else {
		$uri .= $ENV{'SCRIPT_NAME'};
	}
	$::basehref=$::basehost . $uri;
	$::basepath=$uri;
	$::basepath=~s/\/[^\/]*$//g;
	$::basepath="/" if($::basepath eq '');
	$::script=$uri if($::script eq '');
}

=lang ja

=head2 jscss_include

=over 4

=item ͒l

&jscss_include(plugin name, [load list]);

=item o

HTML^O

=item I[o[Ch



=item Tv

vOCJavaScriptACSS̓ǂݍݕ𐶐B

NekyoPyukiWikiƌ݊͂܂B

=back

=cut

sub _jscss_include {
	my($name, $sub)=@_;

	if(!$::jscss_included{$name}) {
		$::jscss_included{$name}=1;
		return if($name!~/^\w{1,64}/);

		foreach("$name%s.css", "$name%s.js") {#, "$::skin_name.$name%s.js") {
#			my $result=&skin_check($_, ".unicode.$::lang", ".$kanjicode.$::lang", ".$::lang", "");
			my $result=&skin_check($_, "");
			if($result ne '') {
				if($result=~/\.js$/) {
					if(!$::jscss_included{"loader"}) {
						$::IN_JSLOADER.=<<EOM;
<script type="text/javascript" src="$::skin_url/loader.js" charset="$::charset"></script>
EOM
						$::jscss_included{"loader"}=2;
					}
					my $pro=$name=~/common/ ? 6 : $name eq "jquery" ? 9 : $name=~/jquery/ ? 7 : 3;
					$::IN_JSFILES.=',"' . "$pro,$::skin_url/$result" . '"';
					$::jscss_included{$name}=2;
				} elsif($result=~/\.css$/) {
					$sub='media="screen"' if($sub eq "");
					$::IN_CSSFILES.=<<EOM;
<link rel="stylesheet" href="$::skin_url/$result" type="text/css" $sub _charset="$::charset" />
EOM
					$::jscss_included{$name}=2;
				}
			}
		}
	}
	return '';
}

=lang ja

=head2 getcookie

=over 4

=item ͒l

&getcookie($cookie̎ID, %cookiez);

=item o

%cookiez

=item I[o[Ch



=item Tv

cookie擾B

=back

=cut

sub _getcookie {
	&load_module("Nana::Cookie");
	return Nana::Cookie::getcookie(@_);
}

=lang ja

=head2 setcookie

=over 4

=item ͒l

&setcookie($cookie̎ID,L,%cookiez);

=item o

Ȃ

=item I[o[Ch



=item Tv

cookieݒ肷邽߂HTTPwb_[ZbgB

Lɂ́Aȉ̐l̂ݐݒłB

E 1F$::cookie_expirebLɂB

E 0FZbV̂ݕۑB

E-1FcookieB

=back

=cut

sub _setcookie {
	&load_module("Nana::Cookie");
	return Nana::Cookie::setcookie(@_);
}

=lang ja

=head2 read_resource

=over 4

=item ͒l

&read_resource(t@C, %\[Xz);

=item o

%\[Xz

=item I[o[Ch



=item Tv

\[Xt@Cǂݍ

=back

=cut

sub _read_resource {
	my ($file,%buf) = @_;
	return %buf if $::_resource_loaded{$file}++;
	open(FILE, $file) or &print_error("(resource:$file)");
	while (<FILE>) {
		s/[\r\n]//g;
		next if /^#/;
		s/\\n/\n/g;
		my ($key, $value) = split(/=/, $_, 2);
#		\[XEUC or UTF-8ł邱ƂMp				# comment
#		$buf{$key} = &code_convert(\$value, $::defaultcode);	# comment
		$buf{$key}=$value;
		$buf{$key}=$::resource_patch{$key} if(defined($::resource_patch{$key}));
	}
	close(FILE);
	return %buf;
}

=lang ja

=head2 armor_name

=over 4

=item ͒l

&armor_name();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

ȉ̕ϊsȂB

EWikiNameWikiName

EWikiNameł͂ȂmmWikiNameł͂Ȃnn

=back

=cut

sub _armor_name {
	my ($name) = @_;
	return ($name =~ /^$wiki_name$/o) ? $name : "[[$name]]";
}

=lang ja

=head2 unarmor_name

=over 4

=item ͒l

&armor_name();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

ȉ̕ϊsȂB

EWikiNameWikiName

EmmWikiNameł͂ȂnnWikiNameł͂Ȃ

=back

=cut

sub _unarmor_name {
	my ($name) = @_;
	return ($name =~ /^$bracket_name$/o) ? $1 : $name;
}

=lang ja

=head2 is_bracket_name

=over 4

=item ͒l

&is_bracket_name();

=item o

uPbgł邩̃tO

=item I[o[Ch



=item Tv

uPbgł邩̃tOԂB

=back

=cut

sub _is_bracket_name {
	my ($name) = @_;
	return ($name =~ /^$bracket_name$/o) ? 1 : 0;
}

=lang ja

=head2 dbmname

=over 4

=item ͒l

&dbmname();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

DBpHEXϊB

=back

=cut

sub _dbmname {
	my ($name) = @_;
#	$name =~ s/(.)/uc unpack('H2', $1)/eg;				# comment
	$name =~ s/(.)/$::_dbmname_encode{$1}/g;
	return $name;
}

=lang ja

=head2 undbmname

=over 4

=item ͒l

&undbmname();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

DBpHEXϊꂽ߂

=back

=cut

sub _undbmname {
	my ($name) = @_;
#	$name =~ s/(.)/uc unpack('H2', $1)/eg;					# comment
	$name =~ s/([0-9A-F][0-9A-F])/$::_dbmname_decode{$1}/g;
	return $name;
}

=lang ja

=head2 decode

=over 4

=item ͒l

&decode();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

URLGR[hꂽfR[hB

=back

=cut

sub _decode {
	my ($s) = @_;
	$s =~ tr/+/ /;
#	$s =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack("C", hex($1))/eg;	# better ? 	# comment
	$s =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/chr(hex($1))/eg;
	# add 0.2.0-p1	# comment
	$s =~ s/%(25)/chr(hex($1))/eg;
	return $s;
}

=lang ja

=head2 encode

=over 4

=item ͒l

&encode();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

URLGR[hB

=back

=cut

sub _encode {
	my ($encoded) = @_;
#	$encoded =~ s/(\W)/'%' . unpack('H2', $1)/eg;		# comment
	$encoded =~ s/(\W)/$::_urlescape{$1}/g;
	return $encoded;
}

=lang ja

=head2 get_now

=over 4

=item ͒l

Ȃ

=item o



=item I[o[Ch



=item Tv

ݓ擾B

=back

=cut

sub _get_now {
	my (@week) = qw(Sun Mon Tue Wed Thu Fri Sat);
	my ($sec, $min, $hour, $day, $mon, $year, $weekday) = localtime(time);
	$weekday = $week[$weekday];
	return sprintf("%d-%02d-%02d ($weekday) %02d:%02d:%02d",
		$year + 1900, $mon + 1, $day, $hour, $min, $sec);
}


=lang ja

=head2 load_module

=over 4

=item ͒l

&load_module(W[);

=item o

W[

=item I[o[Ch



=item Tv

PerlW[ǂݍ

=back

=cut

sub _load_module{
	my $mod = shift;
	return $mod if $::_module_loaded{$mod}++;
	# bug fix 0.2.0-p3								# comment
	if($mod=~/^[\w\:]{1,64}$/) {
		eval qq( require $mod; );
		unless($@) {
			$::debug.="Load perl module $mod\n";
		} else {
			$::debug.="Load perl module $mod failed\n";
		}
		$mod=undef if($@);
		return $mod;
	}
	return undef;
}

=lang ja

=head2 code_convert

=over 4

=item ͒l

&code_convert(, [euc|sjis|utf8|jis] [,̓R[h]);

=item o



=item I[o[Ch



=item Tv

LN^[R[hϊB

=back

=cut

sub _code_convert {
	my ($contentref, $kanjicode, $icode) = @_;
	if($$contentref ne '') {
		if ($::lang eq 'ja') {
			if($::code_method{ja} eq 'jcode.pl') {
				die "Unsupport jcode.pl";
			} else {
				&load_module("Jcode");
				$$contentref .= '';
				# add v 0.2.0								# comment
				$$contentref=~s/\xef\xbd\x9e/\xe3\x80\x9c/g;# ` # comment
				&Jcode::convert($contentref, $kanjicode, $icode);
				# add v 0.2.0								# comment
				$$contentref=~s/\xe3\x80\x9c/\xef\xbd\x9e/g;# ` # comment
			}
		}
	}
	return $$contentref;
}

=lang ja

=head2 is_exist_page

=over 4

=item ͒l

&is_exist_page(y[W);

=item o

y[W݂ꍇ^

=item I[o[Ch



=item Tv

y[W݂邩`FbN

=back

=cut

sub _is_exist_page {
	my ($name) = @_;
	return 0 if($name eq '');
	foreach(keys %::fixedpage) {
		if($::fixedpage{$_} ne '' && $_ eq $name) {
			return 1;
		}
	}
	return ($use_exists) ?
		 exists($::database{$name}) ? 1 : 0
		: $::database{$name} ne '' ? 1 : 0;
}

=lang ja

=head2 trim

=over 4

=item ͒l

&trim();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

̑O(p)󔒂菜

=back

=cut

sub _trim {
	my ($s) = @_;
	$s =~ s/^\s*(\S+)\s*$/$1/o; # trim		# comment
	return $s;
}

=lang ja

=head2 escape

=over 4

=item 

&escape();

=item o

`ꂽ

=item I[o[Ch



=item Tv

HTML^OGXP[vB

=back

=cut

sub _escape {
	return &htmlspecialchars(shift);
}

=lang ja

=head2 unescape

=over 4

=item ͒l

&unescape();

=item o

`ꂽ

=item I[o[Ch



=item Tv

GXP[vꂽHTML^O߂B

=back

=cut

sub _unescape {
	my $s=shift;
	$s=~s/\&(amp|lt|gt|quot);/$::_unescape{$1}/g;
	return $s;
}

=lang ja

=head2 htmlspecialchars

=over 4

=item ͒l

&htmlspecialchars(,[SGMLԂ߂Ȃꍇ1]);

=item o

ϊꂽ

=item I[o[Ch



=item Tv

HTMLGXP[vB

=back

=cut

sub _htmlspecialchars {
	my($s,$flg)=@_;
	return $s if($s!~/([<>"&])/);

	$s=~s/([<>"&])/$::_htmlspecial{$1}/g;
	return $s if($flg eq 1);
	# 當ASGML̎QƂ߂						# comment
	$s=~s/&amp;($::_sgmlescape);/&$1;/ig;
	# 10iA16iԎQƂ߂							# comment
	$s=~s/&amp;#([0-9A-Fa-fXx]+)?;/&#$1;/g;
	return $s;
}

=lang ja

=head2 javascriptspecialchars

=over 4

=item ͒l

&javaspecialchars();

=item o

ϊꂽ

=item I[o[Ch



=item Tv

JavaScriptSɎsł悤ɃGXP[vB

=back

=cut

sub _javascriptspecialchars {
	my($s)=@_;
	$s=&htmlspecialchars($s);
	$s=~s|'|&apos;|g;
	return $s;
}


=lang ja

=head2 fopen

=over 4

=item 

&fopen(filename or URL, mode);

=item o

t@Cnh

=item I[o[Ch



=item Tv

t@C܂URLI[vPHP݊֐

=back

=cut

sub _fopen {
	my ($fname, $fmode) = @_;
	my $_fname;
	my $fp;

	# HTTP: 								# comment
	if ($fname =~ /^http:\/\//) {
		$fname =~ m!(http:)?(//)?([^:/]*)?(:([	0-9]+)?)?(/.*)?!;
		my $host = ($3 ne "") ? $3 : "localhost";
		my $port = ($5 ne "") ? $5 : 80;
		my $path = ($6 ne "") ? $6 : "/";
		if ($::proxy_host) {
			$host = $::proxy_host;
			$port = $::proxy_port;
			$path = $fname;
		}
		my ($sockaddr, $ip);
		$fp = new FileHandle;
		if ($host =~ /^(\d+).(\d+).(\d+).(\d+)$/) {
			$ip = pack('C4', split(/\./, $host));
		} else {
			#HOSTIPɒ						# comment
			$ip = inet_aton($host) || return 0;	# Host Not Found.
		}
		$sockaddr = pack_sockaddr_in($port, $ip) || return 0; # Can't Create Socket address.	# comment
		socket($fp, PF_INET, SOCK_STREAM, 0) || return 0;	# Socket Error.
		connect($fp, $sockaddr) || return 0;	# Can't connect Server.
		autoflush $fp(1);
		print $fp "GET $path HTTP/1.1\r\nHost: $host\r\n\r\n";
		return $fp;
	} else {
		$fmode = lc($fmode);

		if ($fmode eq 'w') {
			$_fname = ">$fname";
		} elsif ($fmode eq 'w+') {
			$_fname = "+>$fname";
		} elsif ($fmode eq 'a') {
			$_fname = ">>$fname";
		} elsif ($fmode eq 'r') {
			$_fname = $fname;
		} else {
			return 0;
		}
		if (open($fp, $_fname)) {
			return $fp;
		}
	}
	return 0;
}

=lang ja

=head2 	escapeoff

=over 4

=item 

&escapeoff(0 or 1 or 2)

=item o

$::IN_HEAD

=item I[o[Ch



=item Tv

IEɂāA͗ĔpESpL[ƊԈႦāAESCL[ŉĂ܂̂j~B

CJavaScript́Askin/common?.js ɋLqĂ܂B

=back

=cut

sub _escapeoff {
	my ($flg)=@_;
	return if($::escapeoff_exec eq 1);
	$::escapeoff_exec = 1;

	return if($::form{cmd}!~/edit/);

	$::IN_JSHEAD.=<<EOM;
ev.add("onload", "ebak");
ev.add("onkeydown", @{[$flg eq 2 ? '"eprsc"' : $flg eq 1 ? '"eprs"' : '"eprn"']});
EOM
}

=lang ja

=head2 gettz

=over 4

=item ͒l

Ȃ

=item o

GMTƂ̍̎

=item I[o[Ch



=item Tv

GMTƂ̍(hour)ŕԂB

=back

=cut

sub _gettz {
	if($::TZ eq '') {
		my $now=time();
		$::TZ=(timegm(localtime($now))-timegm(gmtime($now)))/3600;
	}
	return $::TZ;
}

=lang ja

=head2 getwday

=over 4

=item ͒l

&getwday($year,$mon,$mday);

=item o

jԍ

=item I[o[Ch



=item Tv

̗j߂

=back

=cut

sub _getwday {
	my($year, $mon, $mday) = @_;

	if ($mon == 1 or $mon == 2) {
		$year--;
		$mon += 12;
	}
	return int($year + int($year / 4) - int($year / 100) + int($year / 400)
		+ int((13 * $mon + 8) / 5) + $mday) % 7;
}

=lang ja

=head2 lastday

=over 4

=item ͒l

&lastday($year,$mon);

=item o

̔N̍ŏI

=item I[o[Ch



=item Tv

̔N̍ŏI߂B

=back

=cut

sub _lastday {
	my($year,$mon)=@_;
	return  (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31)[$mon - 1]
		+ ($mon == 2 and $year % 4 == 0 and
		($year % 400 == 0 or $year % 100 != 0));
}

=lang ja

=head2 dateinit

=over 4

=item ͒l

Ȃ

=item o

Ȃ

=item I[o[Ch



=item Tv

ߑOEߌ̕Aj擾B

=back

=cut

sub _dateinit {
	my $i=0;

	foreach(split(/,/,$::resource{"date_ampm_en"})) {
		$::_date_ampm[$i++]=$_;
	}
	$i=0;
	foreach(split(/,/,$::resource{"date_ampm_".$::lang})) {
		$::_date_ampm_locale[$i++]=$_;
	}
	$i=0;
	foreach(split(/,/,$::resource{"date_weekday_en"})) {
		$::_date_weekday[$i++]=$_;
	}
	$i=0;
	foreach(split(/,/,$::resource{"date_weekday_".$::lang})) {
		$::_date_weekday_locale[$i++]=$_;
	}
	$i=0;
	foreach(split(/,/,$::resource{"date_weekday_en_short"})) {
		$::_date_weekday_short[$i++]=$_;
	}
	$i=0;
	foreach(split(/,/,$::resource{"date_weekday_".$::lang."_short"})) {
		$::_date_weekday_locale_short[$i++]=$_;
	}
}

=lang ja

=head2 date

=over 4

=item ͒l

&date(format [,unixtime] [,"gmtime"]);

=item o

ϊꂽt

=item I[o[Ch



=item Tv

t擾Aw肵PHPɕϊB

=back

=cut

sub _date {
	my ($format, $tm, $gmtime) = @_;
	my %weekday;
	my %ampm;

	# yday:0-365 $isdst Summertime:1/not:0
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
		$gmtime ne '' && @_ > 2
			? ($tm+0 > 0 ? gmtime($tm) : gmtime(time))
			: ($tm+0 > 0 ? localtime($tm) : localtime(time));

	$year += 1900;
	my $hr12=$hour=>12 ? $hour-12:$hour;

	# am / pm strings										# comment
	$ampm{en}=$::_date_ampm[$hour>11 ? 1 : 0];
	$ampm{$::lang}=$::_date_ampm_locale[$hour>11 ? 1 : 0];

	# weekday strings										# comment
	$weekday{en}=$::_date_weekday[$wday];
	$weekday{en_short}=$::_date_weekday_short[$wday];
	$weekday{$::lang}=$::_date_weekday_locale[$wday];
	$weekday{$::lang."_short"}=$::_date_weekday_locale_short[$wday];

	# RFC 822 (only this)									# comment
	if($format=~/r/) {
		return &date("D, j M Y H:i:s O",$tm,$gmtime);
	}
	# gmtime & C^[lbg							# comment
	if($format=~/[OZB]/) {
		my $gmt=&gettz;
		$format =~ s/O/sprintf("%+03d:00", $gmt)/ge;	# GMT Time	# comment
		$format =~ s/Z/sprintf("%d", $gmt*3600)/ge;		# GMT Time secs...	# comment
		my $swatch=(($tm-$gmt+90000)/86400*1000)%1000;	# GMT +1:00ɂāAP1000beatɂ	# comment
														# {Ԃ̏ꍇAAM08:00=000	# comment
		$format =~ s/B/sprintf("%03d", int($swatch))/ge;# internet time	# comment
	}

	# UNIX time
	$format=~s/U/sprintf("%u",$tm)/ge;	# unix time

	$format=~s/lL/\x2\x13/g;	# lL:escape -y			# comment
	$format=~s/DL/\x2\x14/g;	# DL:escape j-yj	# comment
	$format=~s/D/\x2\x12/g;		# D:escape Sun-Sat			# comment
	$format=~s/aL/\x1\x13/g;	# aL:escape ߑO or ߌ	# comment
	$format=~s/AL/\x1\x14/g;	# AL:escape ̑啶		# comment
	$format=~s/l/\x2\x11/g;		# l:escape Sunday-Saturday	# comment
	$format=~s/a/\x1\x11/g;		# a:escape am pm			# comment
	$format=~s/A/\x1\x12/g;		# A:escape AM PM			# comment
	$format=~s/M/\x3\x11/g;		# M:escape Jan-Dec			# comment
	$format=~s/F/\x3\x12/g;		# F:escape January-December	# comment

	# 邤NǍ̓								# comment
	if($format=~/[Lt]/) {
		my $uru=($year % 4 == 0 and ($year % 400 == 0 or $year % 100 != 0)) ? 1 : 0;
		$format=~s/L/$uru/ge;
		$format=~s/t/(31, $uru ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31)[$mon]/ge;
	}

	# year													# comment
	$format =~ s/Y/$year/ge;	# Y:4char ex)1999 or 2003	# comment
	$year = $year % 100;
	$year = "0" . $year if ($year < 10);
	$format =~ s/y/$year/ge;	# y:2char ex)99 or 03		# comment

	# month													# comment
	my $month = ('January','February','March','April','May','June','July','August','September','October','November','December')[$mon];
	$mon++;									# mon is 0 to 11 add 1	# comment
	$format =~ s/n/$mon/ge;					# n:1-12				# comment
	$mon = "0" . $mon if ($mon < 10);
	$format =~ s/m/$mon/ge;					# m:01-12				# comment

	# day													# comment
	$format =~ s/j/$mday/ge;				# j:1-31		# comment
	$mday = "0" . $mday if ($mday < 10);
	$format =~ s/d/$mday/ge;				# d:01-31		# comment

	# hour													# comment
	$format =~ s/g/$hr12/ge;				# g:1-12		# comment
	$format =~ s/G/$hour/ge;				# G:0-23		# comment
	$hr12 = "0" . $hr12 if ($hr12 < 10);
	$hour = "0" . $hour if ($hour < 10);
	$format =~ s/h/$hr12/ge;				# h:01-12		# comment
	$format =~ s/H/$hour/ge;				# H:00-23		# comment

	# minutes												# comment
	$format =~ s/k/$min/ge;					# k:0-59		# comment
	$min = "0" . $min if ($min < 10);
	$format =~ s/i/$min/ge;					# i:00-59		# comment

	# second												# comment
	$format =~ s/S/$sec/ge;					# S:0-59		# comment
	$sec = "0" . $sec if ($sec < 10);
	$format =~ s/s/$sec/ge;					# s:00-59		# comment

	$format =~ s/w/$wday/ge;				# w:0(Sunday)-6(Saturday)	# comment

	$format =~ s/I/$isdst/ge;	# I(Upper i):1 Summertime/0:Not	# comment

	$format =~ s/\x1\x11/$ampm{en}/ge;			# a:am or pm		# comment
	$format =~ s/\x1\x12/uc $ampm{en}/ge;		# A:AM or PM		# comment
	$format =~ s/\x1\x13/$ampm{$::lang}/ge;		# A:ߑO or ߌ	# comment
	$format =~ s/\x1\x14/uc $ampm{$::lang}/ge;	# ̑啶		# comment

	$format =~ s/\x2\x11/$weekday{en}/ge;		# l(lower L):Sunday-Saturday	# comment
	$format =~ s/\x2\x12/$weekday{en_short}/ge;	# D:Mon-Sun	# comment
	$format =~ s/\x2\x13/$weekday{"$::lang" . "_short"}/ge;	# D:Mon-Sun	# comment
	$format =~ s/\x2\x14/$weekday{$::lang}/ge;

	$format =~ s/\x3\x11/substr($month,0,3)/ge;	# M:Jan-Dec				# comment
	$format =~ s/\x3\x12/$month/ge;				# F:January-December	# comment

	$format =~ s/z/$yday/ge;	# z:days/year 0-366					# comment
	return $format;

	# moved date format document to plugin/date.inc.pl or date.inc.pl.ja.pod	# comment
}

=lang ja

=head2 http_date

=over 4

=item ͒l

&http_date(unixtime);

=item o

ϊꂽt

=item I[o[Ch



=item Tv

HTTPwb_p̓tɕϊB

=back

=cut

sub _http_date {
	my ($tm)=@_;
	if($tm+0 eq 0) {
		$tm=time;
	}
	if(&load_module("HTTP::Date")) {
		my $tmp;
		eval {
			$tmp=&HTTP::Date::time2str($tm);
		};
		if($tmp ne '') {
			return $tmp;
		}
	}
	return &date("D, j M Y G:i:S",0,"gmtime");
}

=lang ja

=head2 getremotehost

=over 4

=item 

&getremotehost;

=item o

$ENV{REMOTE_HOST}

=item I[o[Ch



=item Tv

[gzXgo͂B

=back

=cut

sub _getremotehost {
	&load_module("Nana::RemoteHost");
	Nana::RemoteHost::get();
}

1;
