######################################################################
# wiki_db.cgi - This is PyukiWiki, yet another Wiki clone.
# $Id: wiki_db.cgi,v 1.49 2012/09/11 00:42:59 papu Exp $
# Build on 2012-09-11 08:19:40
#
# "PyukiWiki" ver 0.2.1-beta2 $$
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=EUC-JP 1TAB=4Spaces
######################################################################

=head1 NAME

wiki_db.cgi - This is PyukiWiki, yet another Wiki clone.

=head1 DESCRIPTION

PyukiWiki is yet another Wiki clone. Based on YukiWiki

PyukiWiki can treat Japanese WikiNames (enclosed with [[ and ]]).
PyukiWiki provides 'InterWiki' feature, RDF Site Summary (RSS),
and some embedded commands (such as [[# comment]] to add comments).

=head1 SEE ALSO

=over 4

=item PyukiWiki/Dev/Specification/wiki_db.cgi

L<http://pyukiwiki.info/PyukiWiki/Dev/Specification/wiki_db.cgi/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/lib/wiki_db.cgi?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/lib/wiki_db.cgi?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/lib/wiki_db.cgi?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/lib/wiki_db.cgi?view=log>

=back

=head1 AUTHOR

=over 4

=item Nekyo

obsoleted

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright (C) 2004-2007 by Nekyo.

Copyright (C) 2005-2012 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

=lang ja

=head2 open_db

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

ǡ١򳫤

=back

=cut

sub _open_db {
	&dbopen($::data_dir,\%::database);
}


=lang ja

=head2 open_info_db

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

infoǡ١򳫤

=back

=cut

sub _open_info_db {
	&dbopen($::info_dir,\%::infobase);
}

=lang ja

=head2 dbopen

=over 4

=item 

&dbopen(dir, \%db);

=item 

ʤ

=item С饤



=item 

ǡ١򳫤

=back

=cut

sub _dbopen {
	my($dir,$db)=@_;
	if ($modifier_dbtype eq 'dbmopen') {
		dbmopen(%$db, $dir, 0666) or &print_error("(dbmopen) $dir");
	} elsif($modifier_dbtype eq 'AnyDBM_File') {
		tie(%$db, "AnyDBM_File", $dir, O_RDWR|O_CREAT, 0666) or &print_error("(tie AnyDBM_File) $dir");
	} else {	# Nana::YukiWikiDB or Nana::GDBM	# comment
		tie(%$db, "$modifier_dbtype", $dir) or &print_error("(tie $modifier_dbtype) $dir");
	}
	return %db;
}

=lang ja

=head2 dbopen

=over 4

=item 

&dbopen_gz(dir, \%db);

=item 

ʤ

=item С饤



=item 

gzip̥ǡ١򳫤

=back

=cut

sub _dbopen_gz {#nocompact
	my($dir,$db)=@_;#nocompact
	if ($modifier_dbtype eq 'dbmopen') {#nocompact
		dbmopen(%$db, $dir, 0666) or &print_error("(dbmopen) $dir");#nocompact
	} elsif($modifier_dbtype eq 'AnyDBM_File') {#nocompact
		tie(%$db, "AnyDBM_File", $dir, O_RDWR|O_CREAT, 0666) or &print_error("(tie AnyDBM_File) $dir");#nocompact
	} else {	# Nana::YukiWikiDB_GZIP	# comment#nocompact
		tie(%$db, "Nana::YukiWikiDB_GZIP", $dir) or &print_error("(tie Nana::YukiWikiDB_GZIP) $dir");#nocompact
	}#nocompact
	return %db;#nocompact
}#nocompact

=lang ja

=head2 close_db

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

ǡ١Ĥ

=back

=cut

sub _close_db {
	&dbclose(\%::database);
}

=lang ja

=head2 close_info_db

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

infoǡ١Ĥ

=back

=cut

sub _close_info_db {
	&dbclose(\%::infobase);
}

=lang ja

=head2 dbclose

=over 4

=item 

&dbclose(\%db);

=item 

ʤ

=item С饤



=item 

ǡ١򳫤

=back

=cut

sub _dbclose {
	my($db)=@_;
	if ($modifier_dbtype eq 'dbmopen') {
		dbmclose(%$db);
	} else {
		untie(%$db);
	}
}

=lang ja

=head2 opendiff

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

diffǡ١򳫤

=back

=cut

sub _open_diff {
	&dbopen($::diff_dir,\%::diffbase);
}

=lang ja

=head2 close_diff

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

diffǡ١Ĥ롣

=back

=cut

sub _close_diff {
	&dbclose(\%::diffbase);
}

=lang ja

=head2 openbackup

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

backupǡ١򳫤

=back

=cut

sub _open_backup {#nocompact
	&dbopen_gz($::backup_dir,\%::backupbase);#nocompact
}#nocompact

=lang ja

=head2 close_backup

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

backupǡ١Ĥ롣

=back

=cut

sub _close_backup {#nocompact
	&dbclose(\%::backupbase);#nocompact
}#nocompact

=lang ja

=head2 init_db

=over 4

=item 

ʤ

=item 

ʤ

=item С饤



=item 

ǡ١󥸥

=back

=cut

sub _init_db {
	if($::modifier_dbtype eq 'Nana::YukiWikiDB') {
		&load_module("Nana::YukiWikiDB");
		&load_module("Nana::YukiWikiDB_GZIP");#nocompact
	} elsif($::modifier_dbtype eq 'Nana::GDBM') {
		&load_module("Nana::GDBM");
	}
}
1;
