######################################################################
# location.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: location.inc.pl,v 1.404 2012/09/11 00:43:28 papu Exp $
# Build on 2012-09-11 08:25:25
#
# "PyukiWiki" ver 0.2.1-beta2 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
# v0.2.1 2012/04/25 0のとき、Locationヘッダで移動するようにした。
# v0.1.9 2011/02/23 新規作成
#
# *Usage
# #location(http:〜 or wikiページ名)
#
# 安全の為、凍結されているページでしか実行されません。
######################################################################
use strict;
$::location::move_time=3
	if(!defined($::location::move_time));
$location::301redirect=1
	if(!defined($location::301redirect));
sub plugin_location_convert {
	my $url=shift;
	return if(!&is_frozen($::form{mypage}));
	if(&is_exist_page($url)) {
		my $tmp=&make_cookedurl($url);
		$url="$::basehref$tmp";
	}
	if($::location::move_time eq 0) {
		print &http_header(
			@{[$location::301redirect eq 1
				? 	"Status: 301"
				: 	"Status: 302"
			]},
			"Location: $url",
			$::HTTP_HEADER
			);
		exit;
	}
	$::IN_HEAD.=<<EOM;
<meta http-equiv="Refresh" content="$::location::move_time;url=$url" />
EOM
	my $body=$::resource{location_plugin_message};
	$body=~s/\$URL/$url/g;
	return $body;
}
1;
__END__
