######################################################################
# wiki_db.cgi - This is PyukiWiki, yet another Wiki clone.
# $Id: wiki_db.cgi,v 1.48 2012/09/11 00:43:23 papu Exp $
# Build on 2012-09-11 08:23:41
#
# "PyukiWiki" ver 0.2.1-beta2 $$
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
sub _open_db {
	&dbopen($::data_dir,\%::database);
}
sub _open_info_db {
	&dbopen($::info_dir,\%::infobase);
}
sub _dbopen {
	my($dir,$db)=@_;
	if ($modifier_dbtype eq 'dbmopen') {
		dbmopen(%$db, $dir, 0666) or &print_error("(dbmopen) $dir");
	} elsif($modifier_dbtype eq 'AnyDBM_File') {
		tie(%$db, "AnyDBM_File", $dir, O_RDWR|O_CREAT, 0666) or &print_error("(tie AnyDBM_File) $dir");
	} else {	# Nana::YukiWikiDB or Nana::GDBM	# comment
		tie(%$db, "$modifier_dbtype", $dir) or &print_error("(tie $modifier_dbtype) $dir");
	}
	return %db;
}
sub _dbopen_gz {#nocompact
	my($dir,$db)=@_;#nocompact
	if ($modifier_dbtype eq 'dbmopen') {#nocompact
		dbmopen(%$db, $dir, 0666) or &print_error("(dbmopen) $dir");#nocompact
	} elsif($modifier_dbtype eq 'AnyDBM_File') {#nocompact
		tie(%$db, "AnyDBM_File", $dir, O_RDWR|O_CREAT, 0666) or &print_error("(tie AnyDBM_File) $dir");#nocompact
	} else {	# Nana::YukiWikiDB_GZIP	# comment#nocompact
		tie(%$db, "Nana::YukiWikiDB_GZIP", $dir) or &print_error("(tie Nana::YukiWikiDB_GZIP) $dir");#nocompact
	}#nocompact
	return %db;#nocompact
}#nocompact
sub _close_db {
	&dbclose(\%::database);
}
sub _close_info_db {
	&dbclose(\%::infobase);
}
sub _dbclose {
	my($db)=@_;
	if ($modifier_dbtype eq 'dbmopen') {
		dbmclose(%$db);
	} else {
		untie(%$db);
	}
}
sub _open_diff {
	&dbopen($::diff_dir,\%::diffbase);
}
sub _close_diff {
	&dbclose(\%::diffbase);
}
sub _open_backup {#nocompact
	&dbopen_gz($::backup_dir,\%::backupbase);#nocompact
}#nocompact
sub _close_backup {#nocompact
	&dbclose(\%::backupbase);#nocompact
}#nocompact
sub _init_db {
	if($::modifier_dbtype eq 'Nana::YukiWikiDB') {
		&load_module("Nana::YukiWikiDB");
		&load_module("Nana::YukiWikiDB_GZIP");#nocompact
	} elsif($::modifier_dbtype eq 'Nana::GDBM') {
		&load_module("Nana::GDBM");
	}
}
1;
