######################################################################
# GoogleSitemaps.pm - This is PyukiWiki, yet another Wiki clone.
# $Id: GoogleSitemaps.pm,v 1.125 2012/10/09 15:04:49 papu Exp $
# Build on 2012-09-25 08:38:45
#
# "Nana::GoogleSitemaps" ver 0.2 $$
# Author: Nanami
# http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=UTF-8 1TAB=4Spaces
######################################################################

package Nana::GoogleSitemaps;
use strict;
use vars qw($VERSION);

$VERSION = '0.2';

# The constructor.
sub new {
	my ($class, %hash) = @_;
	my $self = {
		version => $hash{version},
		encoding => $hash{encoding},
	};
	return bless $self, $class;
}

# Adding item.
sub add_item {
	my ($self, %hash) = @_;
	push(@{$self->{items}}, \%hash);
	return $self->{items};
}

#
sub as_string {
	my ($self) = @_;
	my $doc = <<"EOD";
<?xml version="1.0" encoding="utf-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">

@{[
 map {
  qq{
   <url>
   <loc>$_->{link}</loc>
   <lastmod>$_->{dc_date}</lastmod>
   <priority>$_->{priority}</priority>
   @{[$_->{changefreq} ne '' ? "<changefreq>$_->{changefreq}</changefreq>" : ""]}
   </url>
  }
  } @{$self->{items}}
]}
</urlset>
EOD
}

1;
__END__
