######################################################################
# cdn.inc.pl - This is PyukiWiki yet another Wiki clone
# $Id: cdn.inc.pl,v 1.4 2013/03/30 21:24:18 papu Exp $
# Build 2013-03-29 09:25:38
#
# "PyukiWiki" ver 0.2.1-beta8 $$
# Author Nanami http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
# This is extented plugin.
# To use this plugin, rename to 'cdn.inc.cgi'

$cdn::base{release}="http://cdn.pyukiwiki.info/imagecdn/PyukiWiki/release";
$cdn::base{plugin}="http://cdn.pyukiwiki.info/imagecdn/PyukiWiki/plugins";
$cdn::theme{tdiary}="http://cdn.pyukiwiki.info/imagecdn/tdiary/theme";

sub plugin_cdn_init {
	my $baseversion=$::version;
	$baseversion=~s/-utf8//g;
	$::image_url="$cdn::base{release}/$baseversion/pyukiwiki-$::version/image";
	$::skin_url="$cdn::base{release}/$baseversion/pyukiwiki-$::version/skin";
	return('init'=>1);
}


1;
__DATA__
sub plugin_antispamwiki_setup {
	return(
		ja'=>'PyukiWiki コンテンツデリバリー'',
		en=>'PyukiWiki CDN',
		override=>'',
		require=>'',
		url=>'http://pyukiwiki.info/PyukiWiki/Plugin/ExPlugin/cdn/'
	);
}
__END__

=head1 NAME

cdn.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

Using PyukiWiki CDN

=head1 DESCRIPTION

Display fastest wiki of using PyukiWiki CDN

=head1 USAGE

rename to cdn.inc.cgi

=head1 OVERRIDE

none

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/ExPlugin/cdn

L<http://pyukiwiki.info/PyukiWiki/Plugin/ExPlugin/antispam/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/lib/cdn.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/lib/cdn.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/lib/cdn.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/lib/cdn.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright(C) 2005-2013 by Nanami.

Copyright(C) 2005-2013 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
