######################################################################
# head.inc.pl - This is PyukiWiki yet another Wiki clone
# $Id: head.inc.pl,v 1.233 2013/03/30 21:24:20 papu Exp $
# Build 2013-03-27 07:36:42
#
# "head" ver 1.1 $$
# Author Nanami http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################

$PLUGIN="head";
$VERSION="1.1";

$head::nofreezeexec=0
	if(!defined($head::nofreezeexec));

sub plugin_head_convert {
	my ($eom)=@_;
	if($head::nofreezeexec eq 0) {
		return ' ' if(!&is_frozen($::form{mypage}));
	}
	$::linedata="";
	$::linesave=1;
	$::eom_string=$eom;
	$::eom_string="#head" if($eom eq '');
	$::exec_inlinefunc=\&plugin_head_display;
	return ' '
}

sub plugin_head_display {
	my($text)=@_;
	if($head::nofreezeexec eq 0) {
		return ' ' if(!&is_frozen($::form{mypage}));
	}
	$::IN_HEAD.=$text;
	return ' '
}

1;
__END__
=head1 NAME

head.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 #head(EOM)
 <script type="text/javascript"><!--
 alert("Hello world");
 //--></script>
 EOM

=head1 DESCRIPTION

Insert head tags.

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/sh

L<http://pyukiwiki.info/PyukiWiki/Plugin/Nanami/head/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/head.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/head.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/plugin/head.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/plugin/head.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright(C) 2005-2013 by Nanami.

Copyright(C) 2005-2013 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
