######################################################################
# decode.t - This is PyukiWiki yet another Wiki clone
# $Id: decode.t,v 1.96 2013/03/30 21:24:28 papu Exp $
# Build 2013-03-27 07:44:00
#
# "PyukiWiki" ver 0.2.1-beta8 $$
# Author Nanami
# http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
# XSPKG : NanaXS::func 0.1

use strict;
use warnings;
use Time::HiRes qw(gettimeofday tv_interval);

use Test::More tests => 3;
BEGIN {
	push @INC, "./blib";
	push @INC, "./blib/lib";
	push @INC, "./blib/arch";
	push @INC, "./blib/arch/auto";
};
diag("NanaXS::func load\n");
use_ok('NanaXS::func');

#########################


my $test=q( !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ]^_`abcdefghijklmnopqrstuvwxyz{|}~);


my $test1;
my $test2;

$test1=$test;
$test1 =~ s/(\W)/'%' . unpack('H2', $1)/eg;
$test1 =~ s/\%20/+/g;
$test2=NanaXS::func::decode($test1);

diag("NanaXS::func::decode(short)\n");
ok($test eq $test2, "decode (short)");

my $t0 = [gettimeofday];

diag("NanaXS::func::decode(prepare big data)\n");
my $testbig;
for(my $i=0; $i < 100; $i++) {
	$testbig.=$test;
}
$test=$testbig;
for(my $i=0; $i < 500; $i++) {
	$testbig.=$test;
}

my $t1 = [gettimeofday];
diag(tv_interval ($t0, $t1) . "sec\n");

diag("Nana::XS::func::decode(pure perl)");
$test=$testbig;
$test1=$testbig;
$test1 =~ s/(\W)/'%' . unpack('H2', $1)/eg;
$test1 =~ s/\%20/+/g;

my $t2 = [gettimeofday];
diag(tv_interval ($t1, $t2) . "sec\n");

diag("NanaXS::func::decode(big)\n");
$test2=NanaXS::func::decode($test1);
ok($test eq $test2, "decode (big)");

my $t3 = [gettimeofday];
diag(tv_interval ($t2, $t3) . "sec\n");

exit(0);
