######################################################################
# undbmname.t - This is PyukiWiki yet another Wiki clone
# $Id: undbmname.t,v 1.102 2013/03/30 21:24:28 papu Exp $
# Build 2013-03-27 07:44:02
#
# "PyukiWiki" ver 0.2.1-beta8 $$
# Author Nanami
# http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
# XSPKG : NanaXS::func 0.1

use strict;
use warnings;

use Test::More tests => 3;
BEGIN {
	push @INC, "./blib";
	push @INC, "./blib/lib";
	push @INC, "./blib/arch";
};
use_ok('NanaXS::func');

#########################

my $test=" !\"#\$\%\&\'\*+,-./0123456789:;<=>\?\@ABCDEFGHIJKLMNOPQRRSTUVWXYZ]^_`abcdefghijklmnopqrstuvwxyz{|}~";

my $test1;
my $test2;

$test1=$test;
$test1 =~ s/(.)/uc unpack('H2', $1)/eg;
$test1 =~ s/(.)/uc unpack('H2', $1)/eg;
$test2=NanaXS::func::undbmname($test);

cmp_ok($test1, '=', $test2, "undbmname (short)");

my $testbig;
for(my $i=0; $i < 100; $i++) {
	$testbig.=$test;
}
$test=$testbig;
for(my $i=0; $i < 100; $i++) {
	$testbig.=$test;
}

$test1=$testbig;
$test1 =~ s/(.)/uc unpack('H2', $1)/eg;
$test1 =~ s/(.)/uc unpack('H2', $1)/eg;
$test2=NanaXS::func::undbmname($test);

cmp_ok($test1, '=', $test2, "undbmname (big)");
