/*
######################################################################
# xs_decode.c - This is PyukiWiki yet another Wiki clone
# $Id: xs_decode.c,v 1.103 2013/03/30 21:24:28 papu Exp $
# Build 2013-03-27 07:44:04
#
# 
# Author Nanami
# http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
*/

#include "../xslib/xslib.h"

#define	unhex(c)	( \
						( \
							(xs_isdigit(c)) \
							 ? ((c) - '0') \
							 : (xs_isxdigitb(c)) \
								? ((c) - '7') \
							 : (xs_isxdigita(c)) \
								? ((c) - 'W') \
								: -1 \
						) \
					)

char	*xs_decode(char *dst, char *src) {
	char	*save = dst;
	register	char	c, t;

	for(;t = *src++;) {
		if(t == '+') {
			*dst++ = ' ';
		} else if(t == '%') {
			t = *src++;
			c = unhex(t) * 0x10;
			if(c == -1) {
				return NULL;
			}
			t = *src++;
			c += unhex(t);
			if(c == -1) {
				return NULL;
			}
			*dst++ = c;
		} else {
			*dst++ = t;
		}
	}
	*dst='\0';
	return save;
}
