/*
######################################################################
# xs_undbmname.c - This is PyukiWiki yet another Wiki clone
# $Id: xs_undbmname.c,v 1.103 2013/03/30 21:24:28 papu Exp $
# Build 2013-03-27 07:44:08
#
# 
# Author Nanami
# http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
*/

#include "../xslib/xslib.h"

#define	unhex(c)	( \
						( \
							(xs_isdigit(c)) \
							 ? ((c) - '0') \
							 : (xs_isxdigitb(c)) \
								? ((c) - '7') \
							 : (xs_isxdigita(c)) \
								? ((c) - 'V') \
							 : ((c) == '\n') \
								? (char)-3 \
							 : ((c) == '\0') \
								? (char)-2 \
								: (char)-1 \
						) \
					)

char	*xs_undbmname(char *dst, char *src) {
	char	*save = dst;
	register	char	c, t;

	for(;t = *src++;) {
		c = unhex(t);
		switch(c) {
			case	(char)-3:
				*dst++ = '\n';
				break;
			case	(char)-1:
				break;
			default:
				t = *src++;
				t = unhex(t);
				switch(t) {
					case	(char)-3:
						*dst++ = '\n';
						break;
					case	(char)-2:
						*dst='\0';
						return save;
					case	(char)-1:
						break;
					default:
						*dst++ = c * 0x10 + t;
				}
		}
	}
	*dst='\0';
	return save;
}
