#!/usr/bin/env python
#-------------------------------------------------------------------------------
# Name:        
# Purpose:     
#
# Author:      Jia Lu
#
# Created:     09/04/2007
# Copyright:   (c) Jia Lu 2007
# Licence:     <GPL>
#-------------------------------------------------------------------------------

import os
import sys
import re
import wx
import time
import wx.richtext

try:
    import cStringIO
except:
    import StringIO as cStringIO

try:
    import psyco
    #psyco.log()
    #psyco.profile()
    psyco.full()
except:
    pass


import pylogo
import AI

class InputPanel(wx.Panel):
    def __init__(self, parent, id, MainFrame):
        self.MainFrame = MainFrame
        wx.Panel.__init__(self, parent, id)
        self.label = wx.StaticText(self, -1, "SAY: ", size=(30,20))
        self.inputTc = wx.TextCtrl(self, -1,"",style=wx.TE_PROCESS_ENTER)
        self.enterBtn = wx.Button(self,-1, "ENTER", size=(50,20))
        self.enterBtn.SetToolTipString("Enter to chat.")
        
        self.Bind(wx.EVT_BUTTON, self.OnClick, self.enterBtn)
        self.Bind(wx.EVT_TEXT_ENTER, self.OnEnter, self.inputTc)
        
        box = wx.BoxSizer(wx.HORIZONTAL)
        box.Add(self.label, 0)
        box.Add(self.inputTc, 1, wx.EXPAND)
        box.Add(self.enterBtn, 0, wx.EXPAND)
        
        self.SetAutoLayout(False)
        self.SetSizer(box)
        self.Layout()
        self.inputTc.SetFocus()
        
    def OnEnter(self, evt):
        self.OnClick(evt)
        
    def OnClick(self, evt):
        self.enterBtn.Disable()
        inputted = self.inputTc.GetValue()
        if inputted != "":
            self.MainFrame.p2.rtc.BeginTextColour((255, 0, 0))
            self.MainFrame.p2.rtc.WriteText("You Said:")
            self.MainFrame.p2.rtc.EndTextColour()
            self.MainFrame.p2.rtc.WriteText(inputted+"\n")
            self.inputTc.Clear()
            self.inputTc.SetFocus()
            self.printBotWords(AI.AI(inputted))
        self.enterBtn.Enable()

    def printBotWords(self, myword):
        self.MainFrame.p2.rtc.BeginTextColour((0, 0, 255))
        self.MainFrame.p2.rtc.WriteText("Bot Shouted:")
        self.MainFrame.p2.rtc.EndTextColour()
        self.MainFrame.p2.rtc.WriteText(myword+"\n")

class RichTextPanel(wx.Panel):
    def __init__(self, parent, id):
        wx.Panel.__init__(self, parent, id)
##        self.rtc = wx.richtext.RichTextCtrl(self, wx.TE_MULTILINE)
        self.rtc = wx.richtext.RichTextCtrl(self, style=wx.VSCROLL|wx.HSCROLL|wx.NO_BORDER)
        self.rtc.SetEditable(False)
        
        box = wx.BoxSizer(wx.VERTICAL)
        box.Add(self.rtc, 1, wx.EXPAND)

        self.SetAutoLayout(True)
        self.SetSizer(box)
        self.Layout()


class MySplitter(wx.SplitterWindow):
    def __init__(self, parent, ID):
        wx.SplitterWindow.__init__(self, parent, ID,
                                   style = wx.SP_LIVE_UPDATE
                                   )

        self.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGED, self.OnSashChanged)
        self.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGING, self.OnSashChanging)

    def OnSashChanged(self, evt):
        #self.log.WriteText("sash changed to %s\n" % str(evt.GetSashPosition()))
        #print "changed"
        pass

    def OnSashChanging(self, evt):
        #print "changing"
        #self.log.WriteText("sash changing to %s\n" % str(evt.GetSashPosition()))
        # uncomment this to not allow the change
        #evt.SetSashPosition(-1)
        pass

class AppFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, -1, "AI Frame", pos=wx.DefaultPosition,
                size=(800,600), style=wx.DEFAULT_FRAME_STYLE)
        self.initpos = 0
        
        self.SetTitleIcon()
        self.MkStatusbar()
        self.MkMenus()

        #self.MkCtrls()
        self.MkSplitter()
        
        self.Layout()
       
    def Layout(self):
        self.sizer = wx.BoxSizer(wx.VERTICAL)
        self.sizer.Add(self.sp, 1, wx.EXPAND)
        
        self.SetSizer(self.sizer)
        self.SetAutoLayout(0)
        #self.sizer.Fit(self)


    def MkSplitter(self):
        self.sp = MySplitter(self, -1)
        sty = wx.BORDER_SUNKEN
        #self.p1 = wx.Panel(self.sp, style=sty)
        self.p1 = InputPanel(self.sp, -1, MainFrame=self)
        #self.p1.SetBackgroundColour("light yellow")
        #wx.StaticText(p1, -1, "Panel One", (5,5))

##        self.p2 = wx.Panel(self.sp, style=sty)
        self.p2 = RichTextPanel(self.sp, -1)
        #self.p2.rtc.WriteText("test\ntest\naa\nsfsdf\nadssdf\nsdfsdfsdf\nsdfsfsd\nsdfsdfs\nsdfsdfs\nsdfsdf\nsdfs\nsdf")
        #self.p2.SetBackgroundColour("sky blue")
        #wx.StaticText(self.p2, -1, "Panel One", (5,5))

        self.sp.SetMinimumPaneSize(25)
        self.sp.SplitHorizontally(self.p1, self.p2, 25)
        
##        self.chatMain = wx.richtext.RichTextCtrl(self.p2, -1, style=wx.VSCROLL|wx.HSCROLL|wx.NO_BORDER)
##        #wx.CallAfter(self.chatMain.SetFocus)
##        self.chatMain.WriteText("Test\n")
##        self.chatMain.WriteText("Test\n")

    def SetTitleIcon(self):
        """
            Make an icon on the title bar.
        """
        icon = wx.EmptyIcon()
        icon.CopyFromBitmap(wx.BitmapFromImage(wx.ImageFromStream(cStringIO.StringIO(pylogo.getDataSmall()))))
        self.SetIcon(icon)


    def MkStatusbar(self):
        """
            Make a StatusBar.
        """
        self.sb = MyStatusBar(self)
        self.SetStatusBar(self.sb)

    ### MAKE MENUS FROM HERE ###
    def MkMenus(self):
        self.MainMenu = wx.MenuBar()
        self.AddMenus(self.MainMenu)
        self.SetMenuBar(self.MainMenu)
    
    def AddMenus(self, menu):
        self.AddFileMenu(menu)
        self.AddEditMenu(menu)
        self.AddHelpMenu(menu)

    def AddMenuItem(self, menu, itemText, itemDescription, itemHandler):
        menuId = wx.NewId()
        menu.Append(menuId, itemText, itemDescription)
        self.Bind(wx.EVT_MENU, itemHandler, id=menuId)
        return menuId

    def AddFileMenu(self, menu):
        fileMenu = wx.Menu()
        #self.AddMenuItem(fileMenu, '&New File\tCtrl-N', 'New File', self.OnNewFile)
        #self.AddMenuItem(fileMenu, '&Open File\tCtrl-O', 'Open File', self.OnOpenFile)
        #self.AddMenuItem(fileMenu, '&Save File\tCtrl-S', 'Save File', self.OnSaveFile)
        #self.AddMenuItem(fileMenu, 'Save File &As\tCtrl-A', 'Save File As',self.OnSaveFileAs)
        self.AddMenuItem(fileMenu, 'E&xit\tAlt-X', 'Exit', self.OnExit)
        menu.Append(fileMenu, '&File')

    def AddEditMenu(self, menu):
        editMenu = wx.Menu()
        #self.AddMenuItem(editMenu, 'Cut\tCtrl-X', 'Cut', self.edl.OnCutSelection)
        #self.AddMenuItem(editMenu, '&Copy\tCtrl-C', 'Copy', self.edl.OnCopySelection)
        #self.AddMenuItem(editMenu, 'Paste\tCtrl-V', 'Paste', self.edl.OnPaste)
        #self.AddMenuItem(editMenu, 'Edit preferences', 'Edit Preferences', self.OnEditPreferences)
        #self.AddMenuItem(editMenu, "Switch StatusBar Show", "", self.OnSwitchSB)
        menu.Append(editMenu, '&Edit')

    def AddHelpMenu(self, menu):
        helpMenu = wx.Menu()
        #self.AddMenuItem(helpMenu, 'About', 'About the program', self.OnHelpAbout)
        menu.Append(helpMenu, '&Help')

    def OnEditPreferences(self,evt):
        #wx.StaticText(self.pnl1, -1, "Panel One", (5,5))
        pass

    def OnSwitchSB(self, evt):
        if self.sb.Shown:
            self.sb.Show(False)
        else:
            self.sb.Show(True)

    def OnExit(self, evt):
        self.sb.SetStatusText("Exiting...")
        self.Destroy()

    ### MAKE MENUS END ###

    ### MAKE MAIN WINDOW ###
##    def MkSplitter(self):
##        self.splitter = wx.SplitterWindow(self)
##        self.pnl1 = wx.Panel(self.splitter, style=wx.SUNKEN_BORDER)
##        self.pnl2 = wx.Panel(self.splitter, style=wx.SUNKEN_BORDER)
##        self.pnl1.SetBackgroundColour("white")
##        self.pnl2.SetBackgroundColour("white")
##
##        self.pnl1.Hide()
##        self.pnl2.Hide()
##
##        self.splitter.Initialize(self.pnl1)
##
##        self.splitter.SplitVertically(self.pnl1, self.pnl2, self.initpos)
##
##        self.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGED, self.OnSashChanged)
##        self.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGING, self.OnSashChanging)
##
##    def OnSashChanged(self, evt):
##        pass
##        #self.log.WriteText("sash changed to %s\n" % str(evt.GetSashPosition()))
##
##    def OnSashChanging(self, evt):
##        #pass
##        #self.log.WriteText("sash changing to %s\n" % str(evt.GetSashPosition()))
##        # uncomment this to not allow the change
##        evt.SetSashPosition(-1)
##
##    ### MAKE MAIN WINDOW END ###
##
##    def MkTreeList(self):
##        pass

class MySplashScreen(wx.SplashScreen):
    def __init__(self, parent=None):
        #bitmap = wx.Image(name = "image.jpg").ConvertToBitmap()
        bitmap = wx.BitmapFromImage(wx.ImageFromStream(cStringIO.StringIO(pylogo.getData())))
        splashStyle = wx.SPLASH_CENTRE_ON_SCREEN | wx.SPLASH_TIMEOUT
        splashDuration = 200 # milliseconds
        
        wx.SplashScreen.__init__(self, bitmap, splashStyle, splashDuration, parent)
        self.Bind(wx.EVT_CLOSE, self.OnSplashExit)
        
        # ???
        wx.Yield()

    def OnSplashExit(self, evt):
        self.Hide()
        MyFrame = AppFrame()
        #app.SetTopWindow(MyFrame)
        MyFrame.Show(True)
        # NOTE: freeze without Skip()
        evt.Skip()
        

class MyApp(wx.App):
    def OnInit(self):
        MySplash = MySplashScreen()
        MySplash.Show()
        return True


#----------------------------------------------------------------------------

class MyStatusBar(wx.StatusBar):
    def __init__(self, parent):
        wx.StatusBar.__init__(self,parent,-1)
        self.SetStatusText("Started successfully!",0)

class Initialize:
    def __init__(self):
        self.words_rules = []
        self.replys = []
        
        self.log = open("oper.log","w")
        self.log.write("-- INIT --\n")
        self.PyCheck()
        self.InitMod()

    def __del__(self):
        self.log.close()

    def PyCheck(self):
        if sys.version_info < (2, 4):
            from sets import Set as set
            def sorted(seq):
                seq.sort()
                return seq

            msg = "Requires Python 2.4; some modules may be broken."
            print >> sys.stderr, msg
            # raise SystemExit
        else:
            print >> self.log, "Passed Python version CHECK!"

    def InitMod(self):
##        import imp
        import plugin
        home = os.getcwd()
        modules = []
        moduledir = os.path.join(home, 'modules')
        print moduledir
        plugin.main(moduledir)
        print globals()
##        for filename in sorted(os.listdir(moduledir)):
##            if filename.endswith(".py") \
##                and not filename.startswith("_") \
##                and not os.path.isdir(filename):
##                #try to import
##                name, ext = os.path.splitext(os.path.basename(filename))
##                try:
##                    file,fname,desc = imp.find_module(name,[moduledir])
##                    mod = imp.load_module(name,file,fname,desc)
##                    if hasattr(mod, "f_%s"%name):
##                        print "Installing mod from %s"%mod
##                        try:
##                            print mod
##                        except Exception, e:
##                            print >> sys.stderr, "Error loading %s: %s" % (name, e)
##                    #module = getattr(__import__("modules." + name),name)
##                    #print dir(module)
##                except Exception, e:
##                    print >> sys.stderr, "Error loading %s: %s" % (name, e)
##                #self.replys.append(name)
##                #print "Loaded %s"% name
##                #print
##                #print sys.modules["modules."+name].__all__
##                #print "locals:",locals()[name].__all__
##        #print locals()
##        #print "self.replys:",self.replys
        
        
##        for filename in sorted(os.listdir(moduledir)):
##            # find files named with *.py* ext and not start with *_*
##            if filename.endswith('.py') and not filename.startswith('_'):
##                name, ext = os.path.splitext(os.path.basename(filename))
##                # try to import the module
##                try: module = getattr(__import__('modules.' + name), name)
##                except Exception, e:
##                    print >> sys.stderr, "Error loading %s: %s" % (name, e)
##                else:
##                    if hasattr(module, 'initialize'):
##                        module.initialize(self)
##                    self.register(vars(module))
##                    modules.append(name)
##        if modules:
##            print >> sys.stderr, 'Registered modules:', ', '.join(modules)
##        else:
##            print >> self.log, "Registered modules:", ", ".join(modules)
##
##        self.bindrules()


##    def register(self,variables):
##        for name, obj in variables.iteritems():
##            if hasattr(obj, 'rule'):
##                def wrapper(origin, match, args, self=self, obj=obj):
##                    obj(self, origin, match, args)
##                for key, value in vars(obj).iteritems():
##                    setattr(wrapper, key, value)
##                if hasattr(obj, '__doc__'):
##                    wrapper.__doc__ = obj.__doc__
##                setattr(self, name, wrapper)
##
##    def bindrules(self):
##      self.short = {}
##      self.long = {}
##      self.regexps = []
##      self.always = []
##      self.doc = {}
##
##      for name in dir(self):
##         print >> self.log, "BIND START POINT:"
##         print >> self.log, "----------"
##         print >> self.log, "name = ",name
##         print >> self.log, "----------"
##         method = getattr(self, name)
##         print >> self.log, "method = ",method
##         print >> self.log, "----------"
##         if hasattr(method, 'rule'):
##            rule = getattr(method, 'rule')
##            print >> self.log, "rule = ", rule
##            print >> self.log, "----------"
##
##            if hasattr(method, '__doc__'):
##                if method.__doc__:
##                    self.doc[name] = method.__doc__
##                    print >> self.log, "doc[%s] = %s" % (name, self.doc[name])
##                    print >> self.log, "----------"
##            thread = hasattr(method, 'thread')
##            print >> self.log, "thread = ",thread
##            print >> self.log, "----------"
##
##            if hasattr(method, 'command'):
##                command = method.command
##            else:
##                command = 'PRIVMSG'
##            print >> self.log, "command = ", command
##            print >> self.log, "----------"
##
##            opts = {'thread': thread, 'command': command}
##            print >> self.log, "opts = ",opts
##            print >> self.log, "----------"
##
##            if isinstance(rule, tuple):
##               # 1) e.g. (['cp', 'codepoint'], r'(.*)')
##               if isinstance(rule[0], list):
##                  if rule[1] is not None:
##                    regexp = re.compile(rule[1])
##                  else: regexp = None
##
##                  for short in rule[0]:
##                     self.short[short] = (regexp, method, opts)
##
##               # 2) e.g. ('$nick', ['tell', 'ask'], r'(\S+) (.*)')
##               elif isinstance(rule[0], basestring):
##                  if rule[2] is not None:
##                     regexp = re.compile(rule[2])
##                  else: regexp = None
##
##                  for long in rule[1]:
##                     self.long[long] = (regexp, method, opts)
##
##            # 3) e.g. r'(.*)'
##            elif isinstance(rule, basestring):
##               nick = self.nick.lower()
##               nickpat = ''.join('[%s%s]' % (c, c.upper()) for c in nick)
##               rule = rule.replace('$nick', nickpat)
##               if rule == r'(.*)':
##                  self.always.append((method, opts))
##               else: self.regexps.append((re.compile(rule), method, opts))

def main():
    init = Initialize()
    #app = wx.PySimpleApp()
    app = MyApp(redirect=False)
    #win = AppFrame()
    #win.Show(True)
    
    app.MainLoop()
    

if __name__ == '__main__':
    main()
