/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class InspectorPanel
extends JPanel {
    private EventListenerList aListeners = null;
    private ConsoleObj conObj = null;

    public InspectorPanel() {
        this.initContent();
    }

    public void fireAdminEventDispatched(AdminEvent adminEvent) {
        if (this.aListeners == null) {
            return;
        }
        Object[] objectArray = this.aListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AdminEventListener.class) continue;
            ((AdminEventListener)objectArray[i + 1]).adminEventDispatched(adminEvent);
        }
    }

    public void inspectConsoleObj(ConsoleObj consoleObj, EventListenerList eventListenerList) {
        this.setConsoleObj(consoleObj);
        this.setAdminEventListener(eventListenerList);
        this.inspectorInit();
    }

    public ConsoleObj getConsoleObj() {
        return this.conObj;
    }

    public void refresh() {
        if (this.conObj == null) {
            return;
        }
        this.inspectorInit();
    }

    private void initContent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createWorkPanel();
        if (jPanel != null) {
            this.add((Component)jPanel, "Center");
        }
    }

    private void setConsoleObj(ConsoleObj consoleObj) {
        this.conObj = consoleObj;
    }

    private void setAdminEventListener(EventListenerList eventListenerList) {
        this.aListeners = eventListenerList;
    }

    public abstract JPanel createWorkPanel();

    public abstract void inspectorInit();

    public abstract void clearSelection();

    public abstract void selectedObjectUpdated();
}

