/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.VRFile;
import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class VRFileRAF
extends VRFile {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    private RandomAccessFile myRAF = null;
    private FileChannel myChannel = null;

    public VRFileRAF(File file) {
        this(file, 0xA00000L);
    }

    public VRFileRAF(String string) {
        this(new File(string), 0xA00000L);
    }

    public VRFileRAF(String string, long l) {
        this(new File(string), l);
    }

    public VRFileRAF(File file, long l) {
        super(file, l);
    }

    public synchronized void open() throws IOException, VRFileWarning {
        this.open(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void open(boolean bl) throws IOException, VRFileWarning {
        if (this.opened) {
            return;
        }
        this.myRAF = new RandomAccessFile(this.backingFile, "rw");
        this.myChannel = this.myRAF.getChannel();
        long l = this.myRAF.length();
        if (l == 0L) {
            if (!bl) return;
            this.initNewFile(this.myRAF);
        } else {
            this.loadFile(this.myRAF);
        }
        this.fileSize = this.myRAF.length();
        this.opened = true;
        this.force();
        if (DEBUG) {
            System.out.println("file version=" + this.fileversion);
            System.out.println("number of allocated buffer loaded " + this.allocated.size());
            System.out.println("number of free buffer loaded " + this.numFree);
            System.out.println("safe=" + this.safe);
        }
        if (this.warning == null) return;
        throw this.warning;
    }

    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.backingFile + ": closing...");
            System.out.println("filePointer = " + this.filePointer);
            System.out.println("number of allocated buffers =" + this.allocated.size());
            System.out.println("number of free buffers = " + this.numFree);
        }
        try {
            this.force();
            this.myChannel.close();
            this.myRAF.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.myRAF = null;
        this.reset();
    }

    public synchronized int[] getMap() throws IOException {
        if (!this.opened) {
            try {
                this.open(false);
            }
            catch (VRFileWarning vRFileWarning) {
                // empty catch block
            }
        }
        if (this.allocated.size() + this.numFree == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.allocated.size() + this.numFree];
        int n = this.fileversion == 2 ? 24 : 16;
        long l = n;
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            this.myRAF.seek(l);
            try {
                int n3 = this.myRAF.readInt();
                int n4 = this.myRAF.readInt();
                short s = this.adjustRecordState(this.fileversion, this.myRAF.readShort());
                switch (s) {
                    case 2: 
                    case 4: {
                        nArray[n2++] = n4;
                        break;
                    }
                    case 1: {
                        nArray[n2++] = 0 - n4;
                        break;
                    }
                    case 1001: {
                        bl = true;
                        break;
                    }
                }
                l += (long)n4;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return nArray;
    }

    public synchronized VRecord allocate(int n) throws IOException {
        VRecord vRecord;
        this.checkOpenAndWrite();
        int n2 = (n + 12 + this.blockSize - 1) / this.blockSize * this.blockSize;
        if (DEBUG) {
            System.out.println("allocating " + n2);
        }
        if ((vRecord = this.findFreeRecord(n2)) != null) {
            if (DEBUG) {
                System.out.println("reuse: " + vRecord);
            }
            vRecord.allocate((short)2);
            if (this.safe) {
                vRecord.force();
            }
            --this.numFree;
            ++this.hits;
            if (DEBUG) {
                System.out.println("allocate(): hit, requested " + n + ", allocated " + vRecord.getCapacity());
            }
        } else {
            if (this.numFree > 0) {
                ++this.misses;
            }
            if (this.remaining() < (long)n2) {
                this.growfile(n2 + 12);
            }
            vRecord = this.getNewSlice(n2);
        }
        this.putAllocatedList(vRecord);
        if (DEBUG) {
            System.out.println("allcoated record: " + vRecord);
        }
        return vRecord;
    }

    private long remaining() {
        return this.fileSize - this.filePointer;
    }

    public synchronized void force() throws IOException {
        this.checkOpen();
        this.myChannel.force(false);
    }

    public synchronized void clear(boolean bl) throws IOException {
        if (this.opened) {
            this.reset();
            this.opened = true;
            if (bl) {
                this.myRAF.seek(0L);
                this.initNewFile(this.myRAF);
                this.fileSize = this.myRAF.length();
            } else {
                this.myRAF.seek(0L);
                this.writeFileHeader(this.myRAF);
                this.writeLastRecordHeader(this.myRAF);
                this.filePointer = 24L;
            }
            this.force();
        } else {
            if (!this.backingFile.exists()) {
                return;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.backingFile, "rw");
            if (bl) {
                randomAccessFile.setLength(0L);
            } else {
                this.writeFileHeader(randomAccessFile);
                this.writeLastRecordHeader(randomAccessFile);
            }
            randomAccessFile.getChannel().force(false);
            randomAccessFile.close();
        }
    }

    public String toString() {
        return "VRFileRAF:" + this.backingFile + ":# of buffers=" + this.allocated.size() + ":# of free buffers=" + this.numFree + ":file pointer=" + this.filePointer;
    }

    private void initNewFile(RandomAccessFile randomAccessFile) throws IOException {
        if (DEBUG) {
            System.out.println("Creating new backing file with initial size " + this.initialFileSize);
        }
        randomAccessFile.setLength(this.initialFileSize);
        this.writeFileHeader(randomAccessFile);
        this.writeLastRecordHeader(randomAccessFile);
        this.filePointer = 24L;
    }

    private void loadFile(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray;
        int n;
        if (DEBUG) {
            System.out.println("Loading backing file with size " + randomAccessFile.length());
        }
        if ((n = randomAccessFile.read(byArray = new byte[16])) != 16) {
            throw new IOException(SharedResources.getResources().getString("S3017", this.backingFile, new Integer(n)));
        }
        short s = this.checkFileHeader(ByteBuffer.wrap(byArray));
        if (s == 2) {
            long l = randomAccessFile.readLong();
        }
        boolean bl = false;
        long l = randomAccessFile.getFilePointer();
        long l2 = randomAccessFile.length();
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[12]);
        while (!bl) {
            int n2 = 0;
            VRecordRAF vRecordRAF = null;
            randomAccessFile.seek(l);
            short s2 = this.getRecordState(randomAccessFile, byteBuffer, l, l2);
            switch (s2) {
                case 1: 
                case 2: {
                    n2 = byteBuffer.getInt(4);
                    vRecordRAF = new VRecordRAF(this, l, n2, s2);
                    if (s2 == 2) {
                        if (DEBUG) {
                            System.out.println("loaded record:" + vRecordRAF);
                        }
                        this.putAllocatedList(vRecordRAF);
                    } else {
                        if (DEBUG) {
                            System.out.println("loaded free record:" + vRecordRAF);
                        }
                        this.putFreeList(vRecordRAF, true);
                    }
                    n2 = byteBuffer.getInt(4);
                    break;
                }
                case 1001: {
                    bl = true;
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    long l3 = this.findGoodRecord(randomAccessFile, l, l2);
                    if (l3 == l2) {
                        randomAccessFile.seek(l);
                        this.writeLastRecordHeader(randomAccessFile);
                        bl = true;
                        VRFileRAF.addWarning(this.getNewWarning(), s2, l, byteBuffer, null);
                        break;
                    }
                    n2 = (int)(l3 - l);
                    vRecordRAF = new VRecordRAF(this, l, n2, 1, true);
                    this.putFreeList(vRecordRAF, true);
                    VRFileRAF.addWarning(this.getNewWarning(), s2, l, byteBuffer, vRecordRAF);
                    break;
                }
            }
            if (bl) {
                randomAccessFile.seek(l);
                this.filePointer = l;
                continue;
            }
            l += (long)n2;
        }
    }

    private VRecord getNewSlice(int n) throws IOException {
        long l = this.remaining() - (long)n;
        long l2 = this.filePointer + (long)n;
        VRecordRAF vRecordRAF = new VRecordRAF(this, this.filePointer, n, 2, true);
        this.filePointer += (long)n;
        if (DEBUG) {
            System.out.println("getNewSlice(" + n + "):");
            System.out.println("filePointer advanced to " + this.filePointer);
        }
        this.myRAF.seek(this.filePointer);
        this.writeLastRecordHeader(this.myRAF);
        if (this.safe) {
            ((VRecord)vRecordRAF).force();
        }
        return vRecordRAF;
    }

    private void growfile(int n) throws IOException {
        if (DEBUG) {
            System.out.println("growfile(): need to grow file; remaining = " + this.remaining() + "; need = " + n);
        }
        long l = 0L;
        l = this.isThresholdReached() ? (long)((float)this.fileSize + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)this.fileSize + (float)this.fileSize * this.getGrowthFactor());
        long l2 = this.remaining() + (l - this.fileSize);
        while (l2 < (long)n) {
            l = this.isThresholdReached() ? (long)((float)l + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)l + (float)l * this.getGrowthFactor());
            l2 = this.remaining() + (l - this.fileSize);
            if (!DEBUG) continue;
            System.out.println("Remaing = " + this.remaining() + " needSize = " + n);
        }
        try {
            this.myRAF.setLength(l);
            this.fileSize = l;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.out.println(iOException);
                iOException.printStackTrace();
                System.out.println("file position= " + this.filePointer);
                System.out.println("current file size= " + this.fileSize);
                System.out.println("new file size= " + l);
            }
            throw iOException;
        }
    }

    FileChannel getChannel() {
        this.checkOpen();
        return this.myChannel;
    }

    synchronized int writeByteBuffer(long l, ByteBuffer byteBuffer) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:writeByteBuffer writing " + byteBuffer.remaining() + " bytes from " + l);
        }
        return this.myChannel.write(byteBuffer, l);
    }

    synchronized int readByteBuffer(long l, ByteBuffer byteBuffer) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:readByteBuffer reading " + byteBuffer.remaining() + " bytes from " + l);
        }
        return this.myChannel.read(byteBuffer, l);
    }

    synchronized void writeShort(long l, short s) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:writeShort writing " + s + " from " + l);
        }
        this.myRAF.seek(l);
        this.myRAF.writeShort(s);
    }

    synchronized int readInt(long l) throws IOException {
        this.myRAF.seek(l);
        int n = this.myRAF.readInt();
        if (DEBUG) {
            System.out.println("VRFileRAF:readInt read " + n + " from " + l);
        }
        return n;
    }

    synchronized short readShort(long l) throws IOException {
        this.myRAF.seek(l);
        short s = this.myRAF.readShort();
        if (DEBUG) {
            System.out.println("VRFileRAF:readShort read " + s + " from " + l);
        }
        return s;
    }

    synchronized long readLong(long l) throws IOException {
        this.myRAF.seek(l);
        long l2 = this.myRAF.readLong();
        if (DEBUG) {
            System.out.println("VRFileRAF:readLong read " + l2 + " from " + l);
        }
        return l2;
    }

    synchronized void writeLong(long l, long l2) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:writeLong writing " + l2 + " from " + l);
        }
        this.myRAF.seek(l);
        this.myRAF.writeLong(l2);
    }

    synchronized void writeInt(long l, int n) throws IOException {
        if (DEBUG) {
            System.out.println("VRFRAF:writeInt writing " + n + " from " + l);
        }
        this.myRAF.seek(l);
        this.myRAF.writeInt(n);
    }

    void write(long l, byte[] byArray) throws IOException {
        this.write(l, byArray, 0, byArray.length);
    }

    synchronized void write(long l, byte[] byArray, int n, int n2) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:write writing " + n2 + " bytes from the byte array at offset " + n + " from file position " + l);
        }
        this.myRAF.seek(l);
        this.myRAF.write(byArray, n, n2);
    }

    int read(long l, byte[] byArray) throws IOException {
        return this.read(l, byArray, 0, byArray.length);
    }

    synchronized int read(long l, byte[] byArray, int n, int n2) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:read reading up to " + n2 + " bytes of data from file position " + l + " into a byte array at offset " + n);
        }
        this.myRAF.seek(l);
        int n3 = this.myRAF.read(byArray, n, n2);
        return n3;
    }
}

