/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class JMQByteBufferInputStream
extends InputStream {
    private boolean isClosed = false;
    protected ByteBuffer buf;

    public JMQByteBufferInputStream(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    public synchronized int read() {
        this.ensureOpen();
        try {
            return this.buf.get() & 0xFF;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        if (this.available() == 0) {
            return -1;
        }
        if (n2 > this.available()) {
            n2 = this.available();
        }
        try {
            this.buf.get(byArray, n, n2);
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ": Got exception when reading " + n2 + " bytes from buffer " + this.buf.toString());
            return -2;
        }
        return n2;
    }

    public synchronized long skip(long l) {
        this.ensureOpen();
        if (l > (long)this.available()) {
            l = this.available();
        }
        this.buf.position((int)((long)this.buf.position() + l));
        return l;
    }

    public synchronized int available() {
        this.ensureOpen();
        return this.buf.remaining();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.ensureOpen();
        this.buf.mark();
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.buf.rewind();
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.buf = null;
    }

    private void ensureOpen() {
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }
}

