/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectException;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.MQAddressList;
import com.sun.messaging.jmq.jmsclient.StreamHandler;
import com.sun.messaging.jmq.jmsclient.StreamHandlerFactory;
import com.sun.messaging.jms.JMSException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ConnectionInitiator {
    private ConnectionImpl connection = null;
    private MQAddressList addrList = null;
    private String addrListString = null;
    private boolean useAddressList = false;
    private int nextStart = 0;
    private int reconnectDelay = 3000;
    private int reconnectRetries = 0;
    private int addressListIterations = 0;
    private boolean debug = Debug.debug;
    private static final String PRIORITY = "PRIORITY";
    private static final String RANDOM = "RANDOM";
    private static final String JMS_SERVICE_NAME = "jms";
    private String defaultService = "jms";
    private static final String SSLJMS_SERVICE_NAME = "ssljms";
    public static final int HA_RECONNECT_DELAY = 3000;
    private boolean useStaticAddressList = false;
    private boolean isJMSService = true;
    private volatile boolean shouldRedirect = false;
    private boolean isRedirected = false;
    private String redirectURL = null;

    public ConnectionInitiator(ConnectionImpl connectionImpl) throws javax.jms.JMSException, MalformedURLException {
        this.connection = connectionImpl;
        this.init();
    }

    private void init() throws javax.jms.JMSException, MalformedURLException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.init()");
        }
        this.useStaticAddressList = Boolean.getBoolean("imq.useStaticAddressList");
        String string = this.connection.getTrimmedProperty("imqReconnectInterval");
        if (string != null) {
            this.reconnectDelay = Integer.parseInt(string);
            if (this.connection.isConnectedToHABroker && this.reconnectDelay < 3000) {
                this.reconnectDelay = 3000;
            }
        } else if (this.connection.isConnectedToHABroker) {
            this.reconnectDelay = 3000;
        }
        if ((string = this.connection.getTrimmedProperty("imqReconnectAttempts")) != null) {
            this.reconnectRetries = Integer.parseInt(string);
        }
        if ((string = this.connection.getTrimmedProperty("imqAddressListIterations")) != null) {
            this.addressListIterations = Integer.parseInt(string);
        }
        string = this.connection.getTrimmedProperty("imqAddressList");
        this.addrList = this.createAddressList(string);
        this.setDefaultService(this.addrList);
    }

    protected ConnectionHandler createConnection() throws javax.jms.JMSException {
        return this.createConnection(false);
    }

    protected ConnectionHandler reconnect() throws javax.jms.JMSException, MalformedURLException {
        ConnectionHandler connectionHandler = null;
        if (this.debug) {
            Debug.println("In ConnectionInitiator.reconnect()");
        }
        if (this.connection.isConnectedToHABroker && this.reconnectDelay < 3000) {
            this.reconnectDelay = 3000;
        }
        if (this.shouldRedirect) {
            connectionHandler = this.redirect();
        } else {
            Debug.println("*** Old broker list: " + this.connection.savedJMQBrokerList);
            Debug.println("*** New broker list: " + this.connection.JMQBrokerList);
            if (this.connection.shouldUpdateAddressList()) {
                if (this.debug) {
                    Debug.println("*** updating broker address list: " + this.connection.JMQBrokerList);
                }
                this.resetAddressList(this.connection.JMQBrokerList);
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
            }
            connectionHandler = this.createConnection(true);
        }
        return connectionHandler;
    }

    private ConnectionHandler createConnection(boolean bl) throws javax.jms.JMSException {
        ConnectionHandler connectionHandler = null;
        connectionHandler = this.useAddressList ? this.createConnectionNew(bl) : this.createConnectionOld(bl);
        if (connectionHandler == null && this.debug) {
            Debug.println("*** ConnectionInitiator.createConnection() returning null ConnectionHandler ...");
        }
        return connectionHandler;
    }

    private ConnectionHandler createConnectionNew(boolean bl) throws javax.jms.JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.createConnectionNew()");
        }
        if (bl && this.connection.isConnectedToHABroker) {
            this.addressListIterations = -1;
        }
        Exception[] exceptionArray = new Exception[this.addrList.size()];
        String[] stringArray = new String[this.addrList.size()];
        for (int i = 0; this.addressListIterations <= 0 || i < this.addressListIterations; ++i) {
            for (int j = 0; j < this.addrList.size(); ++j) {
                int n = (this.nextStart + j) % this.addrList.size();
                MQAddress mQAddress = (MQAddress)this.addrList.get(n);
                try {
                    ConnectionHandler connectionHandler = this.createConnection(mQAddress);
                    this.nextStart = this.getNextStartIndex(bl, n);
                    return connectionHandler;
                }
                catch (Exception exception) {
                    if (this.connection.isCloseCalled) {
                        if (exception instanceof javax.jms.JMSException) {
                            throw (javax.jms.JMSException)exception;
                        }
                        ExceptionHandler.handleConnectException(exception, null);
                    }
                    if (this.debug) {
                        Debug.printStackTrace(exception);
                    }
                    exceptionArray[j] = exception;
                    stringArray[j] = mQAddress.toString();
                    if (j == this.addrList.size() - 1) continue;
                    try {
                        Thread.sleep(this.reconnectDelay);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (i == this.addressListIterations - 1) continue;
            try {
                Thread.sleep(this.reconnectDelay);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (exceptionArray.length == 1) {
            MQAddress mQAddress = (MQAddress)this.addrList.get(0);
            String string = mQAddress.getURL();
            ExceptionHandler.handleConnectException(exceptionArray[0], string);
            return null;
        }
        String string = AdministeredObject.cr.getKString("C4003", "[" + this.addrListString + "]");
        ConnectException connectException = new ConnectException(string, "C4003", exceptionArray, stringArray);
        ExceptionHandler.handleConnectException(connectException, "");
        return null;
    }

    private ConnectionHandler createConnectionOld(boolean bl) throws javax.jms.JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.createConnectionOld()");
        }
        int n = 0;
        while (true) {
            if (this.connection.isCloseCalled) {
                String string = AdministeredObject.cr.getKString("C4062");
                JMSException jMSException = new JMSException(string, "C4062");
                ExceptionHandler.throwJMSException(jMSException);
            }
            ++n;
            try {
                if (bl) {
                    this.sleep(this.reconnectDelay);
                }
                return this.openConnection();
            }
            catch (javax.jms.JMSException jMSException) {
                if (!bl) {
                    throw jMSException;
                }
                this.triggerConnectionReconnectFailedEvent(jMSException);
                if (this.reconnectRetries <= 0 || n < this.reconnectRetries) continue;
                throw jMSException;
            }
            break;
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
        }
    }

    private ConnectionHandler openConnection() throws javax.jms.JMSException {
        try {
            String string = this.connection.getProperty("imqConnectionHandler");
            StreamHandler streamHandler = StreamHandlerFactory.getStreamHandler(string);
            return streamHandler.openConnection(this.connection);
        }
        catch (Exception exception) {
            javax.jms.JMSException jMSException = null;
            if (exception instanceof javax.jms.JMSException) {
                jMSException = (javax.jms.JMSException)exception;
            } else {
                jMSException = ExceptionHandler.getJMSException(exception, "C4038", false);
                jMSException.setLinkedException(exception);
            }
            ExceptionHandler.throwJMSException(jMSException);
            return null;
        }
    }

    public boolean getUseAddressList() {
        return this.useAddressList;
    }

    public int getAddrListSize() {
        int n = 0;
        if (this.addrList != null) {
            n = this.addrList.size();
        }
        return n;
    }

    private void setBehavior(MQAddressList mQAddressList) throws javax.jms.JMSException {
        this.useAddressList = false;
        if (mQAddressList != null && mQAddressList.size() > 0) {
            this.useAddressList = true;
            String string = this.connection.getProperty("imqAddressListBehavior");
            if (PRIORITY.equalsIgnoreCase(string)) {
                mQAddressList.setBehavior(1);
            } else if (RANDOM.equalsIgnoreCase(string)) {
                mQAddressList.setBehavior(2);
            } else {
                JMSException jMSException = new JMSException("Bad imqAddressListBehavior value : " + string);
                ExceptionHandler.throwJMSException(jMSException);
            }
            if (this.debug) {
                Debug.println("Address list : \n" + mQAddressList);
            }
        }
    }

    private void validate(MQAddressList mQAddressList) throws javax.jms.JMSException {
    }

    private MQAddressList createAddressList(String string) throws javax.jms.JMSException, MalformedURLException {
        MQAddressList mQAddressList = null;
        this.addrListString = string;
        if (string != null && !string.equals("")) {
            mQAddressList = MQAddressList.createMQAddressList(string);
            this.validate(this.addrList);
        }
        this.setBehavior(mQAddressList);
        this.nextStart = 0;
        return mQAddressList;
    }

    private void setDefaultService(MQAddressList mQAddressList) {
        Debug.println("*** set default service with address list: " + mQAddressList);
        if (mQAddressList != null && mQAddressList.size() > 0) {
            MQAddress mQAddress = (MQAddress)mQAddressList.get(0);
            this.defaultService = mQAddress.getServiceName();
        } else {
            this.defaultService = this.connection.getTrimmedProperty("imqBrokerServiceName");
            if (this.defaultService == null) {
                this.defaultService = JMS_SERVICE_NAME;
            }
        }
        this.isJMSService = JMS_SERVICE_NAME.equalsIgnoreCase(this.defaultService);
        if (this.debug) {
            Debug.println("*** default service name: " + this.defaultService);
        }
    }

    public String getDefaultServiceName() {
        return this.defaultService;
    }

    public void resetAddressList(String string) throws javax.jms.JMSException, MalformedURLException {
        boolean bl = false;
        if (this.useStaticAddressList) {
            return;
        }
        if (string == null || string.length() < 5) {
            return;
        }
        Debug.println("*** isJMSService: " + this.isJMSService);
        Debug.println("*** defaultService: " + this.defaultService);
        if (this.isJMSService) {
            this.addrListString = string;
            this.addrList = this.createAddressList(string);
            bl = true;
        } else if (SSLJMS_SERVICE_NAME.equalsIgnoreCase(this.defaultService)) {
            String string2;
            this.addrListString = string2 = ConnectionInitiator.appendServiceName(string, SSLJMS_SERVICE_NAME);
            this.addrList = this.createAddressList(string2);
            bl = true;
        }
        if (this.debug && bl) {
            Debug.println("**** address list reset: " + this.addrListString);
        }
    }

    public static String appendServiceName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(string3);
            if (string3.indexOf(47, 5) < 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private ConnectionHandler redirect() throws javax.jms.JMSException {
        ConnectionHandler connectionHandler = null;
        try {
            connectionHandler = this.doRedirect();
        }
        catch (Exception exception) {
            connectionHandler = this.createConnectionNew(true);
        }
        return connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionHandler doRedirect() throws javax.jms.JMSException {
        ConnectionHandler connectionHandler = null;
        String string = this.redirectURL;
        try {
            Serializable serializable;
            if (!this.isJMSService) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(this.redirectURL);
                if (this.redirectURL.indexOf(47, 5) < 0) {
                    ((StringBuffer)serializable).append('/');
                }
                ((StringBuffer)serializable).append(SSLJMS_SERVICE_NAME);
                string = ((StringBuffer)serializable).toString();
            }
            if (this.debug) {
                Debug.info("**** ConnectionInitiator: redirecting connection: " + string);
            }
            serializable = MQAddress.createMQAddress(string);
            String string2 = ((MQAddress)serializable).getHandlerClass();
            StreamHandler streamHandler = StreamHandlerFactory.getStreamHandler(string2);
            connectionHandler = streamHandler.openConnection((MQAddress)serializable, this.connection);
            this.isRedirected = true;
            if (this.debug) {
                Debug.info("**** ConnectionInitiator: conn redirected: " + string);
            }
        }
        catch (javax.jms.JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            ExceptionHandler.handleConnectException(exception, this.connection.getLastContactedBrokerAddress());
        }
        finally {
            this.shouldRedirect = false;
        }
        return connectionHandler;
    }

    public void setRedirectURL(String string) {
        this.shouldRedirect = true;
        this.redirectURL = string;
        String string2 = "RedirectURL=" + string;
        ConnectionImpl.connectionLogger.log(Level.INFO, string2);
    }

    public boolean isBrokerRedirected() {
        if (this.isRedirected) {
            this.isRedirected = false;
            return true;
        }
        return false;
    }

    private ConnectionHandler createConnection(MQAddress mQAddress) throws javax.jms.JMSException {
        ConnectionHandler connectionHandler = null;
        if (this.debug) {
            Debug.println("Create connection with MQ address: " + mQAddress);
        }
        if (this.debug) {
            Debug.println("Reconnect retries: " + this.reconnectRetries);
        }
        boolean bl = true;
        int n = 0;
        while (bl) {
            Object object;
            String string;
            if (this.connection.isCloseCalled) {
                if (this.debug) {
                    Debug.println("#### connection.isClosed = true");
                }
                string = AdministeredObject.cr.getKString("C4062");
                object = new JMSException(string, "C4062");
                ExceptionHandler.throwJMSException((javax.jms.JMSException)object);
            }
            try {
                if (this.debug) {
                    Debug.println("#### Connecting to :" + mQAddress + "  counter: " + n);
                }
                string = mQAddress.getHandlerClass();
                object = StreamHandlerFactory.getStreamHandler(string);
                connectionHandler = object.openConnection(mQAddress, this.connection);
                return connectionHandler;
            }
            catch (Exception exception) {
                ++n;
                if (this.debug) {
                    Debug.println("\nConnection Attempt failed.\n, Address = " + mQAddress + ", attempt# = " + n);
                    Debug.printStackTrace(exception);
                }
                object = this.getJMSException(exception);
                this.triggerConnectionReconnectFailedEvent((javax.jms.JMSException)object);
                if (!(exception instanceof javax.jms.JMSException)) {
                    ExceptionHandler.logCaughtException(exception);
                }
                if (this.reconnectRetries < 0 || n < this.reconnectRetries) {
                    this.sleepReconnectDelay();
                    continue;
                }
                ExceptionHandler.throwJMSException((javax.jms.JMSException)object);
            }
        }
        if (connectionHandler == null) {
            Debug.info("**** error: Connection handler is null ****");
        }
        return connectionHandler;
    }

    private void sleepReconnectDelay() {
        try {
            Thread.sleep(this.reconnectDelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private javax.jms.JMSException getJMSException(Exception exception) {
        if (exception instanceof javax.jms.JMSException) {
            return (javax.jms.JMSException)exception;
        }
        javax.jms.JMSException jMSException = ExceptionHandler.getJMSException(exception, "C4038", false);
        jMSException.setLinkedException(exception);
        return jMSException;
    }

    private void triggerConnectionReconnectFailedEvent(javax.jms.JMSException jMSException) {
        this.connection.triggerConnectionReconnectFailedEvent(jMSException);
    }

    private int getNextStartIndex(boolean bl, int n) {
        int n2 = n;
        n2 = this.reconnectRetries > 0 ? n : (bl ? (this.connection.failoverEnabled ? (n + 1) % this.addrList.size() : n) : (n + 1) % this.addrList.size());
        return n2;
    }
}

