/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.zip;

import com.sun.messaging.jmq.jmsclient.Debug;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class Compressor {
    private Deflater deflater = new Deflater();
    private static Compressor compressor = new Compressor();
    private boolean debug = Boolean.getBoolean("imq.zip.debug");

    private Compressor() {
    }

    public static Compressor getInstance() {
        return compressor;
    }

    public synchronized int compress(byte[] byArray, int n, int n2, OutputStream outputStream) throws IOException {
        int n3 = -1;
        Deflater deflater = this.getDefaultDeflater();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
        deflaterOutputStream.write(byArray, n, n2);
        deflaterOutputStream.finish();
        int n4 = deflater.getTotalIn();
        n3 = deflater.getTotalOut();
        if (this.debug) {
            Debug.getPrintStream().println("**** compressor total in: " + n4);
            Debug.getPrintStream().println("**** compressor total out: " + n3);
        }
        deflater.reset();
        return n3;
    }

    private Deflater getDeflater(boolean bl, int n, int n2) {
        Deflater deflater = null;
        if (bl) {
            throw new RuntimeException("No wrap deflater is not Unsupported.");
        }
        deflater = this.deflater;
        deflater.setStrategy(n);
        deflater.setLevel(n2);
        return deflater;
    }

    private Deflater getDefaultDeflater() {
        return this.getDeflater(false, 0, -1);
    }
}

