/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.util.QBrowserUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class ObjectMessageReader
extends PersistedMessageReader {
    Object retrieved_object;

    public File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        return workdirFile;
    }

    public File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessage(msgArchive);
        FileInputStream inFile = null;
        ObjectInputStream inObject = null;
        File body_file = new File(workdirFile.getAbsolutePath() + File.separator + "ObjectMessageBody");
        if (body_file == null || !body_file.exists()) {
            ObjectMessageReader.clearDir(workdirFile);
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg332") + body_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg333"));
        }
        try {
            inFile = new FileInputStream(workdirFile.getAbsolutePath() + File.separator + "ObjectMessageBody");
            inObject = new ObjectInputStream(inFile);
            this.retrieved_object = inObject.readObject();
        }
        catch (Exception thex) {
            ObjectMessageReader.clearDir(workdirFile);
            thex.printStackTrace();
            throw thex;
        }
        finally {
            if (inObject != null) {
                try {
                    inObject.close();
                }
                catch (Exception ie) {}
                inObject = null;
            }
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (Exception ie) {}
                inFile = null;
            }
        }
        return workdirFile;
    }

    public LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        ObjectMessage msg = session.createObjectMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)msg);
        }
        lmc.setMessage((Message)msg);
        lmc.setReal_file_path(this.source_file_path);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)msg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        msg.setObject((Serializable)this.retrieved_object);
        return lmc;
    }

    public LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setMessage_type("ObjectMessage");
        return lmc;
    }
}

