/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;

public final class MapMessageReader
extends PersistedMessageReader {
    private ArrayList map_properties = new ArrayList();

    public final File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile2 = super.readPersistedMessage(msgArchive);
        File def_file = new File(workdirFile2.getAbsolutePath() + File.separator + "MapMessageDef");
        if (!def_file.exists()) {
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg334") + def_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg335"));
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(def_file));
            String line = null;
            while ((line = br.readLine()) != null) {
                Property map_prop = new Property();
                ArrayList ar = QBrowserUtil.parseDelimitedString(line, "@@@HzRpWr@@");
                block13: for (int i = 0; i < ar.size(); ++i) {
                    String token = (String)ar.get(i);
                    switch (i) {
                        case 0: {
                            continue block13;
                        }
                        case 1: {
                            map_prop.setKey(token);
                            continue block13;
                        }
                        case 2: {
                            map_prop.setProperty_type(token);
                            continue block13;
                        }
                        case 3: {
                            Object fullpath = workdirFile2.getAbsolutePath() + File.separator + "MapMessage" + File.separator + token;
                            Property property = map_prop;
                            String string = fullpath;
                            fullpath = this;
                            fullpath = property.getProperty_type();
                            try {
                                if (((String)fullpath).equals("String")) {
                                    property.setProperty_value(MapMessageReader.readFileIntoString(new File(string)));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Int")) {
                                    property.setProperty_value(Integer.parseInt(MapMessageReader.readFileIntoString(new File(string))));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Boolean")) {
                                    property.setProperty_value(Boolean.parseBoolean(MapMessageReader.readFileIntoString(new File(string))));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Bytes")) {
                                    property.setProperty_value(MapMessageReader.readFileIntoBytes(new File(string)));
                                    property.validated_type = 10;
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Byte")) {
                                    property.setProperty_value(Byte.parseByte(MapMessageReader.readFileIntoString(new File(string))));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Double")) {
                                    property.setProperty_value(Double.parseDouble(MapMessageReader.readFileIntoString(new File(string))));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Float")) {
                                    property.setProperty_value(Float.valueOf(Float.parseFloat(MapMessageReader.readFileIntoString(new File(string)))));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (((String)fullpath).equals("Long")) {
                                    property.setProperty_value(Long.parseLong(MapMessageReader.readFileIntoString(new File(string))));
                                    property.selfValidate();
                                    continue block13;
                                }
                                if (!((String)fullpath).equals("Short")) continue block13;
                                property.setProperty_value(Short.parseShort(MapMessageReader.readFileIntoString(new File(string))));
                                property.selfValidate();
                                continue block13;
                            }
                            catch (Exception exception) {
                                fullpath = exception;
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                this.map_properties.add(map_prop);
            }
        }
        catch (Exception e) {
            try {
                MapMessageReader.clearDir(workdirFile2);
                e.printStackTrace();
                throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + e.getMessage() + "\n\nFile=" + def_file.getName());
            }
            catch (Throwable workdirFile2) {
                if (br != null) {
                    br.close();
                }
                throw workdirFile2;
            }
        }
        br.close();
        return workdirFile2;
    }

    public final File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        return workdirFile;
    }

    public final LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        MapMessage mapmsg = session.createMapMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)mapmsg);
        }
        lmc.setMessage((Message)mapmsg);
        lmc.setReal_file_path(this.source_file_path);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)mapmsg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        try {
            block15: for (int i = 0; i < this.map_properties.size(); ++i) {
                Property mapm_body_data = (Property)this.map_properties.get(i);
                String key = mapm_body_data.getKey();
                if (key == null) continue;
                switch (mapm_body_data.validated_type) {
                    case 0: {
                        continue block15;
                    }
                    case 10: {
                        mapmsg.setBytes(key, mapm_body_data.getProperty_valueASBytes());
                        continue block15;
                    }
                    case 1: {
                        mapmsg.setString(key, mapm_body_data.getProperty_valueASString());
                        continue block15;
                    }
                    case 3: {
                        mapmsg.setBoolean(key, mapm_body_data.getProperty_valueASBoolean());
                        continue block15;
                    }
                    case 2: {
                        mapmsg.setInt(key, mapm_body_data.getProperty_valueASInt());
                        continue block15;
                    }
                    case 4: {
                        mapmsg.setByte(key, mapm_body_data.getProperty_valueASByte());
                        continue block15;
                    }
                    case 9: {
                        byte[] bytesarray = QBrowserUtil.extractBytes(mapm_body_data.getProperty_valueASString());
                        if (bytesarray == null) {
                            throw new Exception("Q0021");
                        }
                        mapmsg.setBytes(key, bytesarray);
                        continue block15;
                    }
                    case 5: {
                        byte[] bytesarray;
                        mapmsg.setDouble(key, bytesarray.getProperty_valueASDouble());
                        continue block15;
                    }
                    case 6: {
                        byte[] bytesarray;
                        mapmsg.setFloat(key, bytesarray.getProperty_valueASFloat());
                        continue block15;
                    }
                    case 7: {
                        byte[] bytesarray;
                        mapmsg.setLong(key, bytesarray.getProperty_valueASLong());
                        continue block15;
                    }
                    case 8: {
                        byte[] bytesarray;
                        mapmsg.setShort(key, bytesarray.getProperty_valueASShort());
                    }
                }
            }
        }
        catch (Throwable thex) {
            throw new IOException("MapMessage " + QBrowserV2.resources.getString("qkey.msg.msg336") + thex.getMessage());
        }
        return lmc;
    }

    public final LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setMessage_type("MapMessage");
        return lmc;
    }
}

