/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jms.Message;
import javax.jms.Session;

public class PersistedMessageReader {
    ArrayList headers = new ArrayList();
    ArrayList properties = new ArrayList();
    String source_file_path;

    public static void clearDir(File workdirFile) {
        if (workdirFile == null) {
            return;
        }
        PersistedMessageReader.cleanupWorkDir(workdirFile);
        workdirFile.delete();
    }

    private static void cleanupWorkDir(File workdir) {
        File[] files = workdir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                PersistedMessageReader.cleanupWorkDir(files[i]);
                if (files[i].listFiles().length != 0) continue;
                files[i].delete();
                continue;
            }
            if (!files[i].isFile()) continue;
            try {
                files[i].delete();
                continue;
            }
            catch (Exception exception) {
                Exception ex = exception;
                exception.printStackTrace();
            }
        }
    }

    public LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        Message msg = session.createMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, msg);
        }
        lmc.setMessage(msg);
        lmc.setReal_file_path(this.source_file_path);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, msg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        lmc.setReal_file_path(this.source_file_path);
        return lmc;
    }

    public LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = new LocalMessageContainer();
        lmc.setReal_file_path(this.source_file_path);
        if (this.headers != null) {
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        lmc.setMessage_type("Message");
        return lmc;
    }

    private File readPersistedMessage2(File msgArchive) throws Exception {
        if (msgArchive == null || !msgArchive.exists()) {
            throw new Exception("msg archive file not found. It may be removed.");
        }
        this.source_file_path = msgArchive.getAbsolutePath();
        File workdirFile = null;
        try {
            String workdir = QBrowserUtil.getQBrowserTempFileDir() + "JMS" + System.nanoTime() + File.separator;
            workdirFile = new File(workdir);
            workdirFile.mkdirs();
            this.unZipFile2(msgArchive, workdirFile);
            this.restorePersistedJMSHeaders(new File(workdir + "JMSHeaders.txt"));
        }
        catch (Exception e) {
            PersistedMessageReader.clearDir(workdirFile);
            throw e;
        }
        return workdirFile;
    }

    public File readPersistedMessage(File msgArchive) throws Exception {
        if (msgArchive == null || !msgArchive.exists()) {
            throw new Exception("msg archive file not found. It may be removed.");
        }
        this.source_file_path = msgArchive.getAbsolutePath();
        File workdirFile = null;
        try {
            String workdir = QBrowserUtil.getQBrowserTempFileDir() + "JMS" + System.nanoTime() + File.separator;
            workdirFile = new File(workdir);
            workdirFile.mkdirs();
            this.unZipFile(msgArchive, workdirFile);
            this.restorePersistedJMSHeaders(new File(workdir + "JMSHeaders.txt"));
            this.restorePersistedUserProperties(new File(workdir + "UserProperties.txt"));
        }
        catch (Exception e) {
            PersistedMessageReader.clearDir(workdirFile);
            throw e;
        }
        return workdirFile;
    }

    public File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = this.readPersistedMessage2(msgArchive);
        return workdirFile;
    }

    private static String replaceFileSeparator(String original) {
        Object input = original.toCharArray();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < ((Object)input).length; ++i) {
            if (input[i] == 47) {
                result.append(File.separatorChar);
                continue;
            }
            result.append((char)input[i]);
        }
        return result.toString();
    }

    /*
     * Loose catch block
     */
    private void unZipFile(File file, File tenkaisakiDir) {
        block14: {
            ZipFile zip = null;
            zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> ezip = zip.entries();
            while (ezip.hasMoreElements()) {
                int j;
                ZipEntry ent;
                ZipEntry ze = ent = ezip.nextElement();
                String originalzipentry = ent.getName();
                String targetfilename = tenkaisakiDir.getAbsolutePath() + File.separator + PersistedMessageReader.replaceFileSeparator(originalzipentry);
                File targetfile = new File(targetfilename);
                if (ze.isDirectory()) {
                    targetfile.mkdirs();
                    continue;
                }
                targetfile.getParentFile().mkdirs();
                BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(ze));
                BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(targetfile));
                while ((j = bis.read()) != -1) {
                    bo.write(j);
                }
                bis.close();
                bo.close();
            }
            try {
                zip.close();
            }
            catch (IOException iOException) {
                return;
            }
            catch (Exception exception) {
                try {
                    Exception zipe = exception;
                    exception.printStackTrace();
                    if (zip == null) break block14;
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zip.close();
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private void unZipFile2(File file, File tenkaisakiDir) {
        block19: {
            ZipFile zip = null;
            zip = new ZipFile(file);
            boolean headers_file_found2333333332 = false;
            boolean bodysize_file_found = true;
            String srcfilename = file.getName();
            if (srcfilename.endsWith("_TextMessage.zip") || srcfilename.endsWith("_BytesMessage.zip")) {
                bodysize_file_found = false;
            }
            Enumeration<? extends ZipEntry> ezip = zip.entries();
            while (ezip.hasMoreElements()) {
                ZipEntry ent;
                ZipEntry ze = ent = ezip.nextElement();
                String originalzipentry = ent.getName();
                if (originalzipentry.indexOf("JMSHeaders.txt") != -1) {
                    headers_file_found2333333332 = true;
                } else if (!bodysize_file_found && originalzipentry.endsWith("bodysize")) {
                    bodysize_file_found = true;
                }
                String targetfilename = tenkaisakiDir.getAbsolutePath() + File.separator + PersistedMessageReader.replaceFileSeparator(originalzipentry);
                File targetfile = new File(targetfilename);
                if (ze.isDirectory()) {
                    targetfile.mkdirs();
                } else {
                    int j;
                    targetfile.getParentFile().mkdirs();
                    BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(ze));
                    BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(targetfile));
                    while ((j = bis.read()) != -1) {
                        bo.write(j);
                    }
                    bis.close();
                    bo.close();
                }
                if (!headers_file_found2333333332 || !bodysize_file_found) continue;
            }
            try {
                zip.close();
            }
            catch (IOException headers_file_found2333333332) {
                return;
            }
            catch (Exception exception) {
                try {
                    Exception zipe = exception;
                    exception.printStackTrace();
                    if (zip == null) break block19;
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zip.close();
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
    }

    public static void main(String[] args) {
        Object pmr = new PersistedMessageReader();
        try {
            Object workdir = pmr.readPersistedMessage(new File("c:\\temp1\\IDPSQ96050-3196-1245141988656-00111_Message.zip"));
            PersistedMessageReader.clearDir((File)workdir);
            return;
        }
        catch (Exception exception) {
            Object ex = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseMultipleLineStringProperty(ArrayList store, ArrayList targetArray) {
        StringBuilder sb = new StringBuilder();
        String firstline = (String)store.get(0);
        int secondPar = firstline.substring(1).indexOf("\"");
        String keyvalue = firstline.substring(1, secondPar + 1);
        int startstr = firstline.indexOf("<@begin-@string@>");
        String string_value = firstline.substring(startstr + "<@begin-@string@>".length(), firstline.length());
        sb.append(string_value).append("\n");
        for (int i = 1; i < store.size(); ++i) {
            void var5_9;
            String theline = (String)store.get(i);
            int endstr = theline.indexOf("<@end-@string@>");
            if (endstr != -1) {
                String end2 = theline.substring(0, endstr);
                sb.append(end2).append("\n");
                continue;
            }
            sb.append((String)var5_9).append("\n");
        }
        Property prop = new Property();
        prop.setKey(keyvalue);
        prop.setProperty_type("String");
        prop.setProperty_value(sb.toString());
        try {
            prop.selfValidate();
            targetArray.add(prop);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void parseOneLineStringProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int startstr = orig.indexOf("<@begin-@string@>");
        int endstr = orig.indexOf("<@end-@string@>");
        String string_value = orig.substring(startstr + "<@begin-@string@>".length(), endstr);
        Property prop = new Property();
        prop.setKey(keyvalue);
        prop.setProperty_type("String");
        prop.setProperty_value(string_value);
        try {
            prop.selfValidate();
            targetArray.add(prop);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void parseOneLineBooleanProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int equalspos = orig.indexOf("=");
        if (equalspos != -1) {
            String value1 = orig.substring(equalspos + 1);
            int firstpar = value1.indexOf("\"");
            int secondpar = value1.substring(1).indexOf("\"");
            String target_value = value1.substring(firstpar + 1, secondpar + 1);
            Property prop = new Property();
            prop.setKey(keyvalue);
            prop.setProperty_type("Boolean");
            prop.setProperty_value(new Boolean(target_value));
            try {
                prop.selfValidate();
                targetArray.add(prop);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static void parseOneLineDoubleProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int equalspos = orig.indexOf("=");
        if (equalspos != -1) {
            String value1 = orig.substring(equalspos + 1);
            int firstpar = value1.indexOf("\"");
            int secondpar = value1.substring(1).indexOf("\"");
            String target_value = value1.substring(firstpar + 1, secondpar + 1);
            Property prop = new Property();
            prop.setKey(keyvalue);
            prop.setProperty_type("Double");
            prop.setProperty_value(new Double(target_value));
            try {
                prop.selfValidate();
                targetArray.add(prop);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static void parseOneLineFloatProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int equalspos = orig.indexOf("=");
        if (equalspos != -1) {
            String value1 = orig.substring(equalspos + 1);
            int firstpar = value1.indexOf("\"");
            int secondpar = value1.substring(1).indexOf("\"");
            String target_value = value1.substring(firstpar + 1, secondpar + 1);
            Property prop = new Property();
            prop.setKey(keyvalue);
            prop.setProperty_type("Float");
            prop.setProperty_value(new Float(target_value));
            try {
                prop.selfValidate();
                targetArray.add(prop);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static void parseOneLineIntProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int equalspos = orig.indexOf("=");
        if (equalspos != -1) {
            String value1 = orig.substring(equalspos + 1);
            int firstpar = value1.indexOf("\"");
            int secondpar = value1.substring(1).indexOf("\"");
            String target_value = value1.substring(firstpar + 1, secondpar + 1);
            Property prop = new Property();
            prop.setKey(keyvalue);
            prop.setProperty_type("Int");
            prop.setProperty_value(new Integer(target_value));
            try {
                prop.selfValidate();
                targetArray.add(prop);
                return;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readFileIntoString(File infile) throws Exception {
        Exception exception;
        FileInputStream fi = null;
        ByteArrayOutputStream baos = null;
        try {
            Exception retval;
            fi = new FileInputStream((File)((Object)retval));
            baos = new ByteArrayOutputStream();
            Exception buf = (Exception)new byte[1024];
            int len = 0;
            while ((len = fi.read((byte[])buf)) != -1) {
                baos.write((byte[])buf, 0, len);
            }
            buf = baos.toString();
        }
        catch (Exception exception2) {
            try {
                Exception ie = exception2;
                throw exception2;
            }
            catch (Throwable throwable) {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException iOException) {}
                }
                if (baos == null) throw throwable;
                try {
                    baos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {}
        try {
            baos.close();
            return exception;
        }
        catch (IOException iOException) {
            return exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readFileIntoBytes(File infile) throws Exception {
        Exception exception;
        FileInputStream fi = null;
        ByteArrayOutputStream baos = null;
        try {
            Exception retval;
            fi = new FileInputStream((File)((Object)retval));
            baos = new ByteArrayOutputStream();
            Exception buf = (Exception)new byte[1024];
            int len = 0;
            while ((len = fi.read((byte[])buf)) != -1) {
                baos.write((byte[])buf, 0, len);
            }
            buf = (Exception)baos.toByteArray();
        }
        catch (Exception exception2) {
            try {
                Exception ie = exception2;
                throw exception2;
            }
            catch (Throwable throwable) {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException iOException) {}
                }
                if (baos == null) throw throwable;
                try {
                    baos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {}
        try {
            baos.close();
            return exception;
        }
        catch (IOException iOException) {
            return exception;
        }
    }

    private static void parseOneLineLongProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int equalspos = orig.indexOf("=");
        if (equalspos != -1) {
            String value1 = orig.substring(equalspos + 1);
            int firstpar = value1.indexOf("\"");
            int secondpar = value1.substring(1).indexOf("\"");
            String target_value = value1.substring(firstpar + 1, secondpar + 1);
            Property prop = new Property();
            prop.setKey(keyvalue);
            prop.setProperty_type("Long");
            prop.setProperty_value(new Long(target_value));
            try {
                prop.selfValidate();
                targetArray.add(prop);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static void parseOneLineShortProperty(String orig, ArrayList targetArray) {
        int secondPar = orig.substring(1).indexOf("\"");
        String keyvalue = orig.substring(1, secondPar + 1);
        int equalspos = orig.indexOf("=");
        if (equalspos != -1) {
            String value1 = orig.substring(equalspos + 1);
            int firstpar = value1.indexOf("\"");
            int secondpar = value1.substring(1).indexOf("\"");
            String target_value = value1.substring(firstpar + 1, secondpar + 1);
            Property prop = new Property();
            prop.setKey(keyvalue);
            prop.setProperty_type("Short");
            prop.setProperty_value(new Short(target_value));
            try {
                prop.selfValidate();
                targetArray.add(prop);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private void restorePersistedJMSHeaders(File infile2) throws IOException {
        if (infile2 == null || !infile2.exists()) {
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg329"));
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(infile2));
            boolean inStringProperty = false;
            ArrayList<String> string_store = new ArrayList<String>();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (inStringProperty) {
                    if (line.indexOf("<@end-@string@>") != -1) {
                        string_store.add(line);
                        PersistedMessageReader.parseMultipleLineStringProperty(string_store, this.headers);
                        string_store.clear();
                        inStringProperty = false;
                        continue;
                    }
                    string_store.add(line);
                    continue;
                }
                if (line.indexOf("<@begin-@string@>") != -1) {
                    if (line.indexOf("<@end-@string@>") != -1) {
                        PersistedMessageReader.parseOneLineStringProperty(line, this.headers);
                        continue;
                    }
                    inStringProperty = true;
                    string_store.add(line);
                    continue;
                }
                if (line.indexOf(",Boolean") != -1) {
                    PersistedMessageReader.parseOneLineBooleanProperty(line, this.headers);
                    continue;
                }
                if (line.indexOf(",Double") != -1) {
                    PersistedMessageReader.parseOneLineDoubleProperty(line, this.headers);
                    continue;
                }
                if (line.indexOf(",Float") != -1) {
                    PersistedMessageReader.parseOneLineFloatProperty(line, this.headers);
                    continue;
                }
                if (line.indexOf(",Int") != -1) {
                    PersistedMessageReader.parseOneLineIntProperty(line, this.headers);
                    continue;
                }
                if (line.indexOf(",Long") != -1) {
                    PersistedMessageReader.parseOneLineLongProperty(line, this.headers);
                    continue;
                }
                if (line.indexOf(",Short") == -1) continue;
                PersistedMessageReader.parseOneLineShortProperty(line, this.headers);
            }
        }
        catch (Exception exception) {
            try {
                Exception ex = exception;
                exception.printStackTrace();
                throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + ex.getMessage() + "\n\nFile=" + infile2.getName());
            }
            catch (Throwable infile2) {
                if (br != null) {
                    br.close();
                }
                throw infile2;
            }
        }
        br.close();
        return;
    }

    private void restorePersistedUserProperties(File infile2) throws IOException {
        if (infile2 == null || !infile2.exists()) {
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg330"));
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(infile2));
            boolean inStringProperty = false;
            ArrayList<String> string_store = new ArrayList<String>();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (inStringProperty) {
                    if (line.indexOf("<@end-@string@>") != -1) {
                        string_store.add(line);
                        PersistedMessageReader.parseMultipleLineStringProperty(string_store, this.properties);
                        string_store.clear();
                        inStringProperty = false;
                        continue;
                    }
                    string_store.add(line);
                    continue;
                }
                if (line.indexOf("<@begin-@string@>") != -1) {
                    if (line.indexOf("<@end-@string@>") != -1) {
                        PersistedMessageReader.parseOneLineStringProperty(line, this.properties);
                        continue;
                    }
                    inStringProperty = true;
                    string_store.add(line);
                    continue;
                }
                if (line.indexOf(",Boolean") != -1) {
                    PersistedMessageReader.parseOneLineBooleanProperty(line, this.properties);
                    continue;
                }
                if (line.indexOf(",Double") != -1) {
                    PersistedMessageReader.parseOneLineDoubleProperty(line, this.properties);
                    continue;
                }
                if (line.indexOf(",Float") != -1) {
                    PersistedMessageReader.parseOneLineFloatProperty(line, this.properties);
                    continue;
                }
                if (line.indexOf(",Int") != -1) {
                    PersistedMessageReader.parseOneLineIntProperty(line, this.properties);
                    continue;
                }
                if (line.indexOf(",Long") != -1) {
                    PersistedMessageReader.parseOneLineLongProperty(line, this.properties);
                    continue;
                }
                if (line.indexOf(",Short") == -1) continue;
                PersistedMessageReader.parseOneLineShortProperty(line, this.properties);
            }
        }
        catch (Exception exception) {
            try {
                Exception ex = exception;
                exception.printStackTrace();
                throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + ex.getMessage() + "\n\nFile=" + infile2.getName());
            }
            catch (Throwable infile2) {
                if (br != null) {
                    br.close();
                }
                throw infile2;
            }
        }
        br.close();
        return;
    }
}

