/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.BigDecimalConverter;
import com.jidesoft.converter.BooleanConverter;
import com.jidesoft.converter.ByteConverter;
import com.jidesoft.converter.CacheMap;
import com.jidesoft.converter.CalendarConverter;
import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.CurrencyConverter;
import com.jidesoft.converter.DateConverter;
import com.jidesoft.converter.DefaultArrayConverter;
import com.jidesoft.converter.DefaultObjectConverter;
import com.jidesoft.converter.DimensionConverter;
import com.jidesoft.converter.DoubleConverter;
import com.jidesoft.converter.FileConverter;
import com.jidesoft.converter.FloatConverter;
import com.jidesoft.converter.FontConverter;
import com.jidesoft.converter.FontNameConverter;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.InsetsConverter;
import com.jidesoft.converter.IntegerConverter;
import com.jidesoft.converter.LongConverter;
import com.jidesoft.converter.MonthConverter;
import com.jidesoft.converter.MonthNameConverter;
import com.jidesoft.converter.MultilineStringConverter;
import com.jidesoft.converter.NaturalNumberConverter;
import com.jidesoft.converter.NumberConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.PasswordConverter;
import com.jidesoft.converter.PercentConverter;
import com.jidesoft.converter.PointConverter;
import com.jidesoft.converter.QuarterNameConverter;
import com.jidesoft.converter.RectangleConverter;
import com.jidesoft.converter.RgbColorConverter;
import com.jidesoft.converter.ShortConverter;
import com.jidesoft.converter.StringArrayConverter;
import com.jidesoft.converter.YearNameConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectConverterManager {
    private static CacheMap<ObjectConverter, ConverterContext> _cache = new CacheMap(ConverterContext.DEFAULT_CONTEXT);
    private static ObjectConverter _defaultConverter = new DefaultObjectConverter();
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;

    private static void registerConverter(Class<?> clazz, ObjectConverter objectConverter, ConverterContext converterContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (converterContext == null) {
            converterContext = ConverterContext.DEFAULT_CONTEXT;
        }
        if (_autoInit && !_initing) {
            ObjectConverterManager.initDefaultConverter();
        }
        _cache.register(clazz, objectConverter, converterContext);
    }

    private static void registerConverter(Class<?> clazz, ObjectConverter objectConverter) {
        ObjectConverterManager.registerConverter(clazz, objectConverter, ConverterContext.DEFAULT_CONTEXT);
    }

    private static ObjectConverter getConverter(Class<?> object, ConverterContext converterContext) {
        if (_autoInit) {
            ObjectConverterManager.initDefaultConverter();
        }
        if (converterContext == null) {
            converterContext = ConverterContext.DEFAULT_CONTEXT;
        }
        if ((object = _cache.getRegisteredObject((Class<?>)object, converterContext)) != null) {
            return object;
        }
        return _defaultConverter;
    }

    public static String toString(Object object, Class<?> object2, ConverterContext converterContext) {
        if ((object2 = ObjectConverterManager.getConverter(object2, converterContext)) != null) {
            return object2.toString(object, converterContext);
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static Object fromString(String string, Class<?> object, ConverterContext converterContext) {
        if ((object = ObjectConverterManager.getConverter(object, converterContext)) != null && object.supportFromString$5f33f571()) {
            return object.fromString(string, converterContext);
        }
        return null;
    }

    private static void initDefaultConverter() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            ObjectConverterManager.registerConverter(String.class, new DefaultObjectConverter());
            ObjectConverterManager.registerConverter(char[].class, new PasswordConverter(), PasswordConverter.CONTEXT);
            ObjectConverter objectConverter = new DoubleConverter();
            objectConverter.setFractionDigits(2, 2);
            ObjectConverterManager.registerConverter(Number.class, objectConverter, NumberConverter.CONTEXT_FRACTION_NUMBER);
            objectConverter = new IntegerConverter();
            ObjectConverterManager.registerConverter(Integer.class, objectConverter);
            ObjectConverterManager.registerConverter(Integer.TYPE, objectConverter);
            objectConverter = new NaturalNumberConverter();
            ObjectConverterManager.registerConverter(Integer.class, objectConverter, NaturalNumberConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, objectConverter, NaturalNumberConverter.CONTEXT);
            objectConverter = new LongConverter();
            ObjectConverterManager.registerConverter(Long.class, objectConverter);
            ObjectConverterManager.registerConverter(Long.TYPE, objectConverter);
            objectConverter = new DoubleConverter();
            ObjectConverterManager.registerConverter(Double.class, objectConverter);
            ObjectConverterManager.registerConverter(Double.TYPE, objectConverter);
            objectConverter = new FloatConverter();
            ObjectConverterManager.registerConverter(Float.class, objectConverter);
            ObjectConverterManager.registerConverter(Float.TYPE, objectConverter);
            objectConverter = new ShortConverter();
            ObjectConverterManager.registerConverter(Short.class, objectConverter);
            ObjectConverterManager.registerConverter(Short.TYPE, objectConverter);
            objectConverter = new ByteConverter();
            ObjectConverterManager.registerConverter(Byte.class, objectConverter);
            ObjectConverterManager.registerConverter(Byte.TYPE, objectConverter);
            ObjectConverterManager.registerConverter(Rectangle.class, new RectangleConverter());
            ObjectConverterManager.registerConverter(Point.class, new PointConverter());
            ObjectConverterManager.registerConverter(Insets.class, new InsetsConverter());
            ObjectConverterManager.registerConverter(Dimension.class, new DimensionConverter());
            objectConverter = new BooleanConverter();
            ObjectConverterManager.registerConverter(Boolean.class, objectConverter);
            ObjectConverterManager.registerConverter(Boolean.TYPE, objectConverter);
            ObjectConverterManager.registerConverter(File.class, new FileConverter());
            ObjectConverterManager.registerConverter(String.class, new FontNameConverter(), FontNameConverter.CONTEXT);
            objectConverter = new DateConverter();
            ObjectConverterManager.registerConverter(Date.class, objectConverter);
            ObjectConverterManager.registerConverter(Date.class, objectConverter, DateConverter.DATETIME_CONTEXT);
            ObjectConverterManager.registerConverter(Date.class, objectConverter, DateConverter.TIME_CONTEXT);
            objectConverter = new CalendarConverter();
            ObjectConverterManager.registerConverter(Calendar.class, objectConverter);
            ObjectConverterManager.registerConverter(Calendar.class, objectConverter, DateConverter.DATETIME_CONTEXT);
            ObjectConverterManager.registerConverter(Calendar.class, objectConverter, DateConverter.TIME_CONTEXT);
            ObjectConverterManager.registerConverter(Calendar.class, new MonthConverter(), MonthConverter.CONTEXT_MONTH);
            ObjectConverterManager.registerConverter(Color.class, new RgbColorConverter());
            ObjectConverterManager.registerConverter(Color.class, new HexColorConverter(), ColorConverter.CONTEXT_HEX);
            ObjectConverterManager.registerConverter(Color.class, new RgbColorConverter(true), ColorConverter.CONTEXT_RGBA);
            ObjectConverterManager.registerConverter(Color.class, new HexColorConverter(true), ColorConverter.CONTEXT_HEX_WITH_ALPHA);
            ObjectConverterManager.registerConverter(String[].class, new StringArrayConverter());
            objectConverter = new QuarterNameConverter();
            ObjectConverterManager.registerConverter(Integer.TYPE, objectConverter, QuarterNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.class, objectConverter, QuarterNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Font.class, new FontConverter());
            ObjectConverterManager.registerConverter(String.class, new MultilineStringConverter(), MultilineStringConverter.CONTEXT);
            objectConverter = new CurrencyConverter();
            ObjectConverterManager.registerConverter(Float.class, objectConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Float.TYPE, objectConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.class, objectConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.TYPE, objectConverter, CurrencyConverter.CONTEXT);
            objectConverter = new PercentConverter();
            ObjectConverterManager.registerConverter(Float.class, objectConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Float.TYPE, objectConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.class, objectConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.TYPE, objectConverter, PercentConverter.CONTEXT);
            objectConverter = new MonthNameConverter();
            ObjectConverterManager.registerConverter(Integer.class, objectConverter, MonthNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, objectConverter, MonthNameConverter.CONTEXT);
            objectConverter = new YearNameConverter();
            ObjectConverterManager.registerConverter(Integer.class, objectConverter, YearNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, objectConverter, YearNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(int[].class, new DefaultArrayConverter("; ", Integer.TYPE));
            ObjectConverterManager.registerConverter(Object[].class, new DefaultArrayConverter("; ", Object.class));
            ObjectConverterManager.registerConverter(String[].class, new DefaultArrayConverter("; ", String.class));
            ObjectConverterManager.registerConverter(Date[].class, new DefaultArrayConverter("; ", Date.class));
            ObjectConverterManager.registerConverter(Calendar[].class, new DefaultArrayConverter("; ", Calendar.class));
            ObjectConverterManager.registerConverter(Number[].class, new DefaultArrayConverter("; ", Number.class));
            ObjectConverterManager.registerConverter(Integer[].class, new DefaultArrayConverter("; ", Integer.class));
            ObjectConverterManager.registerConverter(Float[].class, new DefaultArrayConverter("; ", Float.class));
            ObjectConverterManager.registerConverter(Double[].class, new DefaultArrayConverter("; ", Double.class));
            ObjectConverterManager.registerConverter(Long[].class, new DefaultArrayConverter("; ", Long.class));
            ObjectConverterManager.registerConverter(Short[].class, new DefaultArrayConverter("; ", Short.class));
            ObjectConverterManager.registerConverter(int[].class, new DefaultArrayConverter("; ", Integer.TYPE));
            ObjectConverterManager.registerConverter(float[].class, new DefaultArrayConverter("; ", Float.TYPE));
            ObjectConverterManager.registerConverter(double[].class, new DefaultArrayConverter("; ", Double.TYPE));
            ObjectConverterManager.registerConverter(long[].class, new DefaultArrayConverter("; ", Long.TYPE));
            ObjectConverterManager.registerConverter(short[].class, new DefaultArrayConverter("; ", Short.TYPE));
            ObjectConverterManager.registerConverter(BigDecimal.class, new BigDecimalConverter());
            return;
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }
}

