/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SecurityUtils;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JideBoxLayout
implements LayoutManager2,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JideBoxLayout.class.getName());
    private boolean doReset = true;
    protected int _axis;
    protected Container _target;
    private int _gap = 0;
    protected int[] _componentSizes;
    private final HashMap<Component, Object> _constraintMap = new HashMap();
    private boolean _resetWhenInvalidate = true;
    private boolean _alwaysLayout = false;

    public JideBoxLayout(Container container, int n) {
        this(container, n, 0);
    }

    private JideBoxLayout(Container container, int n, int n2) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n;
        this._target = container;
        this._gap = 0;
    }

    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            boolean bl;
            int n2;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + " layoutContainer started");
            }
            Dimension dimension = container.getSize();
            if (dimension.height <= 0 || dimension.width <= 0) {
                return;
            }
            Insets insets = this._target.getInsets();
            if (this.doReset) {
                this._componentSizes = new int[this._target.getComponentCount()];
                n2 = this.getAvailableSize(dimension, insets);
                if ((n2 -= this.getGapSize()) <= 0) {
                    return;
                }
                bl = this.calculateComponentSizes(n2, 0, this._target.getComponentCount());
                if (!bl) {
                    return;
                }
                this.doReset = false;
                if (this._componentSizes.length == 0) {
                    container.repaint();
                }
            } else {
                n2 = 0;
                int[] nArray = this._componentSizes;
                int n3 = this._componentSizes.length;
                for (n = 0; n < n3; ++n) {
                    int n4 = nArray[n];
                    n2 += n4;
                }
                bl = n2 + this.getGapSize() != this.getSizeForPrimaryAxis(dimension);
                if (bl) {
                    n3 = this.getAvailableSize(dimension, insets);
                    if ((n3 -= this.getGapSize()) <= 0) {
                        return;
                    }
                    boolean bl2 = this.calculateComponentSizes(n3, 0, this._target.getComponentCount());
                    n = bl2 ? 1 : 0;
                    if (!bl2) {
                        return;
                    }
                }
            }
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            bl = componentOrientation.isLeftToRight();
            int n5 = this.getSizeForPrimaryAxis(insets, true);
            if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                n5 = dimension.width - n5;
            }
            for (n = 0; n < this._target.getComponentCount(); ++n) {
                Component component = this._target.getComponent(n);
                if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                    this.setComponentToSize(component, this._componentSizes[n], n5 -= this._componentSizes[n], insets, dimension);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + n + " size: " + this._componentSizes[n]);
                    }
                    if (this._componentSizes[n] == 0) continue;
                    n5 -= this._gap;
                    continue;
                }
                this.setComponentToSize(component, this._componentSizes[n], n5, insets, dimension);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("layoutContainer index: " + n + " size: " + this._componentSizes[n]);
                }
                n5 += this._componentSizes[n];
                if (this._componentSizes[n] == 0) continue;
                n5 += this._gap;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("layoutContainer ended");
            }
            return;
        }
    }

    protected boolean calculateComponentSizes(int n, int n2, int n3) {
        boolean bl;
        int n4;
        Component component;
        int n5 = n;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        for (int i = n2; i < n3; ++i) {
            Component component2 = this._target.getComponent(i);
            if (!component2.isVisible()) continue;
            Object object = this._constraintMap.get(component2);
            int n12 = this.getSizeForPrimaryAxis(component2.getMinimumSize());
            component = component2;
            n4 = this.getSizeForPrimaryAxis(component.getPreferredSize());
            if ("fix".equals(object)) {
                n5 -= Math.max(n4, n12);
                continue;
            }
            if ("vary".equals(object)) {
                n8 = i;
                component = component2;
                component.getPreferredSize();
                n6 = n12;
                continue;
            }
            if (n4 > n12) {
                n10 += n4 - n12;
            }
            n9 += n4;
            n7 += n12;
            n11 = i;
        }
        JideBoxLayout jideBoxLayout = this;
        if ("false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false")) && n5 - n6 < 0) {
            return false;
        }
        boolean bl2 = n8 != -1;
        boolean bl3 = bl = n5 - n6 >= n9;
        if (!bl2 || bl2 && !bl) {
            double d = bl ? (n9 == 0 ? 0.0 : (double)(n5 - n6) / (double)n9) : (n10 == 0 ? 0.0 : (double)(n5 - n6 - n7) / (double)n10);
            for (n4 = n2; n4 < n3; ++n4) {
                Component component3 = this._target.getComponent(n4);
                if (!component3.isVisible()) {
                    this.setComponentSize(n4, 0);
                    continue;
                }
                Object object = this._constraintMap.get(component3);
                n5 = this.getSizeForPrimaryAxis(component3.getMinimumSize());
                component = component3;
                int n13 = this.getSizeForPrimaryAxis(component.getPreferredSize());
                if ("fix".equals(object)) {
                    this.setComponentSize(n4, Math.max(n13, n5));
                    continue;
                }
                if ("vary".equals(object)) {
                    this.setComponentSize(n4, n6);
                    continue;
                }
                if (bl) {
                    this.setComponentSize(n4, (int)((double)n13 * d));
                    continue;
                }
                this.setComponentSize(n4, n5 + (int)((double)(n13 - n5) * d));
            }
        } else {
            for (int i = n2; i < n3; ++i) {
                Component component4 = this._target.getComponent(i);
                if (!component4.isVisible()) {
                    this.setComponentSize(i, 0);
                    continue;
                }
                Object object = this._constraintMap.get(component4);
                n7 = this.getSizeForPrimaryAxis(component4.getMinimumSize());
                component = component4;
                n10 = this.getSizeForPrimaryAxis(component.getPreferredSize());
                if (!"fix".equals(object) && "vary".equals(object)) {
                    this.setComponentSize(i, n5 - n9);
                    continue;
                }
                this.setComponentSize(i, Math.max(n10, n7));
            }
        }
        int n14 = 0;
        for (int i = n2; i < n3; ++i) {
            n14 += this._componentSizes[i];
        }
        if (n14 != n) {
            if (n8 != -1) {
                this.setComponentSize(n8, this._componentSizes[n8] + (n - n14));
            } else if (n11 != -1) {
                this.setComponentSize(n11, this._componentSizes[n11] + (n - n14));
            }
        }
        return true;
    }

    private void setComponentSize(int n, int n2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setComponentSize index: " + n + " size: " + n2);
        }
        this._componentSizes[n] = n2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.layoutReset();
    }

    @Override
    public Dimension minimumLayoutSize(Container object) {
        int n = 0;
        int n2 = 0;
        Insets insets = this._target.getInsets();
        object = ((Component)object).getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this._target.getComponentCount(); ++i) {
                Component component = this._target.getComponent(i);
                if (!component.isVisible()) continue;
                Object object2 = this._constraintMap.get(component);
                Dimension dimension = component.getMinimumSize();
                if ("fix".equals(object2)) {
                    JideBoxLayout jideBoxLayout = this;
                    n += jideBoxLayout.getSizeForPrimaryAxis(component.getPreferredSize());
                } else {
                    n += this.getSizeForPrimaryAxis(dimension);
                }
                int n3 = this.getSizeForSecondaryAxis(dimension);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n + this.getGapSize(), n2);
        }
        return new Dimension(n2, n + this.getGapSize());
    }

    @Override
    public Dimension preferredLayoutSize(Container object) {
        int n = 0;
        int n2 = 0;
        Insets insets = this._target.getInsets();
        object = ((Component)object).getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this._target.getComponentCount(); ++i) {
                Serializable serializable = this._target.getComponent(i);
                if (!serializable.isVisible()) continue;
                serializable = serializable.getPreferredSize();
                n += this.getSizeForPrimaryAxis((Dimension)serializable);
                int n3 = this.getSizeForSecondaryAxis((Dimension)serializable);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        if (this._axis == 0) {
            return new Dimension(n + this.getGapSize(), n2);
        }
        return new Dimension(n2, n + this.getGapSize());
    }

    private int getGapSize() {
        if (this._gap == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            if (!this._target.getComponent(i).isVisible()) continue;
            ++n;
        }
        return Math.max(0, n - 1) * this._gap;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this._constraintMap.remove(component);
        if (component instanceof JideSplitPaneDivider) {
            this.layoutReset();
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            this._constraintMap.put(component, "flexible");
        } else {
            this._constraintMap.put(component, object);
        }
        this.layoutReset();
    }

    private void layoutReset() {
        this.doReset = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this + " layoutReset");
        }
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized void invalidateLayout(Container object) {
        block8: {
            block7: {
                boolean bl;
                Serializable serializable = this;
                if (((JideBoxLayout)serializable)._resetWhenInvalidate) break block7;
                serializable = object;
                object = this;
                if (((JideBoxLayout)object)._componentSizes == null) {
                    bl = true;
                } else {
                    int n = 0;
                    object = ((JideBoxLayout)object)._componentSizes;
                    int n2 = ((JideBoxLayout)object)._componentSizes.length;
                    for (int i = 0; i < n2; ++i) {
                        Object object2 = object[i];
                        if (object2 <= 0) continue;
                        ++n;
                    }
                    int n3 = 0;
                    for (n2 = 0; n2 < ((Container)serializable).getComponentCount(); ++n2) {
                        if (!((Container)serializable).getComponent(n2).isVisible()) continue;
                        ++n3;
                    }
                    bl = n3 != n;
                }
                if (!bl) break block8;
            }
            this.layoutReset();
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private int getAvailableSize(Dimension dimension, Insets insets) {
        if (insets == null) {
            return this.getSizeForPrimaryAxis(dimension);
        }
        return this.getSizeForPrimaryAxis(dimension) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
        if (insets != null) {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(Math.max(n2, 0), Math.max(insets.top, 0), Math.max(n, 0), Math.max(dimension.height - (insets.top + insets.bottom), 0));
                return;
            }
            component.setBounds(Math.max(insets.left, 0), Math.max(n2, 0), Math.max(dimension.width - (insets.left + insets.right), 0), Math.max(n, 0));
            return;
        }
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            component.setBounds(Math.max(n2, 0), 0, Math.max(n, 0), Math.max(dimension.height, 0));
            return;
        }
        component.setBounds(0, Math.max(n2, 0), Math.max(dimension.width, 0), Math.max(n, 0));
    }

    private int getSizeForPrimaryAxis(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    private int getSizeForSecondaryAxis(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.height;
        }
        return dimension.width;
    }

    private int getSizeForPrimaryAxis(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }
        if (bl) {
            return insets.top;
        }
        return insets.bottom;
    }

    private int getSizeForSecondaryAxis(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }
        if (bl) {
            return insets.left;
        }
        return insets.right;
    }

    public final Map<Component, Object> getConstraintMap() {
        return this._constraintMap;
    }

    protected static int resolveAxis(int n, ComponentOrientation componentOrientation) {
        block1: {
            block0: {
                if (n != 2) break block0;
                n = componentOrientation.isHorizontal() ? 0 : 1;
                break block1;
            }
            if (n != 3) break block1;
            n = componentOrientation.isHorizontal() ? 1 : 0;
        }
        return n;
    }

    public final boolean isResetWhenInvalidate() {
        return this._resetWhenInvalidate;
    }

    public final void setResetWhenInvalidate(boolean bl) {
        this._resetWhenInvalidate = bl;
    }
}

