/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCacheEntry;
import com.jidesoft.swing.GradientInfo;
import java.awt.image.BufferedImage;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

final class GradientCache {
    private GradientCacheEntry[] gradients;
    private int size;
    private int threshold = 16;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();

    GradientCache() {
        this.loadFactor = 0.75f;
        this.gradients = new GradientCacheEntry[16];
    }

    final BufferedImage retrieve(GradientInfo gradientInfo) {
        int n = gradientInfo.length;
        Object object = this.getGradients();
        int n2 = ((GradientCacheEntry[])object).length;
        int n3 = n;
        object = object[n3 &= n2 - 1];
        while (object != null) {
            Object object2 = object;
            object2 = (GradientInfo)((SoftReference)object2).get();
            try {
                if (object2 != null && ((GradientCacheEntry)object).length == n && ((GradientInfo)object2).isEquivalent(gradientInfo)) {
                    return ((GradientCacheEntry)object).gradient;
                }
            }
            catch (NullPointerException nullPointerException) {}
            object = ((GradientCacheEntry)object).next;
        }
        return null;
    }

    final Object store(GradientInfo gradientCacheEntryArray, BufferedImage bufferedImage) {
        boolean bl;
        Object object;
        GradientCacheEntry gradientCacheEntry;
        GradientCacheEntry[] gradientCacheEntryArray2;
        block8: {
            GradientCacheEntry gradientCacheEntry2;
            gradientCacheEntryArray2 = this.getGradients();
            int n = gradientCacheEntryArray2.length;
            int n2 = gradientCacheEntryArray.length;
            n = n2 & n - 1;
            gradientCacheEntry = gradientCacheEntryArray2[n];
            GradientCacheEntry[] gradientCacheEntryArray3 = gradientCacheEntryArray;
            object = gradientCacheEntry;
            while (object != null && (GradientInfo)(gradientCacheEntry2 = object).get() != null) {
                if (((GradientCacheEntry)object).length == gradientCacheEntryArray3.length && ((GradientInfo)(gradientCacheEntry2 = object).get()).isEquivalent((GradientInfo)gradientCacheEntryArray3)) {
                    bl = false;
                    break block8;
                }
                object = ((GradientCacheEntry)object).next;
            }
            bl = true;
        }
        if (!bl) {
            System.err.println("Duplicate entry found!");
        }
        gradientCacheEntryArray2[n] = new GradientCacheEntry((GradientInfo)gradientCacheEntryArray, bufferedImage, this.queue, gradientCacheEntry);
        if (++this.size >= this.threshold) {
            int n = gradientCacheEntryArray2.length << 1;
            object = this;
            gradientCacheEntryArray = ((GradientCache)object).getGradients();
            int n3 = gradientCacheEntryArray.length;
            if (n3 == 0x40000000) {
                ((GradientCache)object).threshold = Integer.MAX_VALUE;
            } else {
                GradientCacheEntry[] gradientCacheEntryArray4 = new GradientCacheEntry[n];
                super.moveEntries(gradientCacheEntryArray, gradientCacheEntryArray4);
                ((GradientCache)object).gradients = gradientCacheEntryArray4;
                if (((GradientCache)object).size >= ((GradientCache)object).threshold >> 1) {
                    ((GradientCache)object).threshold = (int)((float)n * 0.75f);
                } else {
                    super.cleanOldCacheEntries();
                    super.moveEntries(gradientCacheEntryArray4, gradientCacheEntryArray);
                    ((GradientCache)object).gradients = gradientCacheEntryArray;
                }
            }
        }
        return null;
    }

    private GradientCacheEntry[] getGradients() {
        this.cleanOldCacheEntries();
        return this.gradients;
    }

    private void moveEntries(GradientCacheEntry[] gradientCacheEntryArray, GradientCacheEntry[] gradientCacheEntryArray2) {
        for (int i = 0; i < gradientCacheEntryArray.length; ++i) {
            GradientCacheEntry gradientCacheEntry = gradientCacheEntryArray[i];
            gradientCacheEntryArray[i] = null;
            while (gradientCacheEntry != null) {
                GradientCacheEntry gradientCacheEntry2 = gradientCacheEntry.next;
                Object t = gradientCacheEntry.get();
                if (t == null) {
                    gradientCacheEntry.next = null;
                    gradientCacheEntry.gradient = null;
                    --this.size;
                } else {
                    int n = gradientCacheEntryArray2.length;
                    int n2 = gradientCacheEntry.length;
                    gradientCacheEntry.next = gradientCacheEntryArray2[n2 &= n - 1];
                    gradientCacheEntryArray2[n2] = gradientCacheEntry;
                }
                gradientCacheEntry = gradientCacheEntry2;
            }
        }
    }

    private void cleanOldCacheEntries() {
        GradientCacheEntry gradientCacheEntry;
        block0: while ((gradientCacheEntry = (GradientCacheEntry)this.queue.poll()) != null) {
            GradientCacheEntry gradientCacheEntry2;
            int n = this.gradients.length;
            int n2 = gradientCacheEntry.length;
            GradientCacheEntry gradientCacheEntry3 = gradientCacheEntry2 = this.gradients[n2 &= n - 1];
            while (gradientCacheEntry3 != null) {
                GradientCacheEntry gradientCacheEntry4 = gradientCacheEntry3.next;
                if (gradientCacheEntry3 == gradientCacheEntry) {
                    if (gradientCacheEntry2 == gradientCacheEntry) {
                        this.gradients[n2] = gradientCacheEntry4;
                    } else {
                        gradientCacheEntry2.next = gradientCacheEntry4;
                    }
                    gradientCacheEntry.next = null;
                    gradientCacheEntry.gradient = null;
                    --this.size;
                    continue block0;
                }
                gradientCacheEntry2 = gradientCacheEntry3;
                gradientCacheEntry3 = gradientCacheEntry4;
            }
        }
    }
}

