/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class iASBrokerAdmin {
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWD = "admin";
    private QueueConnectionFactory qcf;
    private QueueConnection connection;
    private QueueSession session;
    private Queue requestQueue;
    private TemporaryQueue replyQueue;
    private QueueSender sender;
    protected QueueReceiver receiver;
    private int timeout = 5000;

    public iASBrokerAdmin(String string, String string2) {
        try {
            this.qcf = new QueueConnectionFactory();
            this.qcf.setConnectionType("ADMIN");
            this.qcf.setProperty("imqBrokerHostName", string);
            this.qcf.setProperty("imqBrokerHostPort", string2);
            this.connection = this.qcf.createQueueConnection("admin", "admin");
            this.connection.start();
            this.session = this.connection.createQueueSession(false, 2);
            this.requestQueue = this.session.createQueue("__JMQAdmin");
            this.replyQueue = this.session.createTemporaryQueue();
            this.sender = this.session.createSender(this.requestQueue);
            this.sender.setDeliveryMode(1);
            this.receiver = this.session.createReceiver((Queue)this.replyQueue);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendHelloMessage() throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 28);
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        Message message = null;
        try {
            message = this.receiver.receive((long)this.timeout);
            message.acknowledge();
            this.checkReplyTypeStatus(message, 29, "HELLO_REPLY");
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public void sendGetDestinationsMessage() throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 20);
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public Vector receiveGetDestinationsReplyMessage() throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiver.receive((long)this.timeout);
            objectMessage.acknowledge();
            this.checkReplyTypeStatus((Message)objectMessage, 21, "GET_DESTINATIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        return null;
    }

    public void sendCreateDestinationMessage(DestinationInfo destinationInfo) throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 10);
            objectMessage.setObject((Serializable)destinationInfo);
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public void receiveCreateDestinationReplyMessage() throws BrokerAdminException {
        Message message = null;
        try {
            message = this.receiver.receive((long)this.timeout);
            message.acknowledge();
            this.checkReplyTypeStatus(message, 11, "CREATE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public void sendShutdownMessage() throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 38);
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public void receiveShutdownReplyMessage() throws BrokerAdminException {
        Message message = null;
        try {
            message = this.receiver.receive((long)this.timeout);
            this.checkReplyTypeStatus(message, 39, "SHUTDOWN_REPLY");
        }
        catch (JMSException jMSException) {
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
    }

    public void close() {
        try {
            this.sender.close();
            this.receiver.close();
            this.session.close();
            this.connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkReplyTypeStatus(Message message, int n, String string) {
        int n2 = -1;
        int n3 = -1;
        if (message == null && n == 39) {
            return;
        }
        try {
            n2 = message.getIntProperty("JMQMessageType");
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
            System.exit(1);
        }
        try {
            n3 = message.getIntProperty("JMQStatus");
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
            System.exit(1);
        }
        if (n == n2 && n3 == 200) {
            return;
        }
        System.out.println("Error occurred while checking the reply.");
        System.exit(1);
    }
}

