package jp.sourceforge.qrcode.util;

import javax.microedition.lcdui.*;

public class QRCodeUtility {
	public static int[][] parseImage(Image image) {
        int width  = image.getWidth();
		int height = image.getHeight();
			
        int[] pixels = new int[width * height];
        image.getRGB(pixels, 0, width, 0, 0, width, height);
        int[][] result = new int[width][height];
		
		for (int x = 0; x < width; x++) {
			for (int y = 0; y < height; y++) {                    
				result[x][y] = pixels[y * width + x];
			}
		}
		return result;
	}
	
	public static int sqrt(int val) {
		//return (int)Math.sqrt(val);
		//don't use Math function, estimate sqrt via newton's method
		//example estimate sqrt of n
		//x_new=(x_old + n / x_old)/2,  loop untill x_new=x_old
		//initially select x_old=1
		//or using http://www.azillionmonkeys.com/qed/sqroot.html
	    //System.out.print(val + ", " + (int)Math.sqrt(val) + ", ");
	    int temp, g=0, b = 0x8000, bshft = 15;
	    do {
	        if (val >= (temp = (((g << 1) + b)<<bshft--))) {
	           g += b;
	           val -= temp;
	        }
	    } while ((b >>= 1) > 0);
	    //System.out.println(" g="+g);
	    return g;		
	}	
}
