#ifndef QRK_FONT_H
#define QRK_FONT_H

/*!
  \file
  \brief フォント設定

  \author Satofumi KAMIMURA

  $Id: Font.h 695 2009-03-29 22:24:00Z satofumi $
*/

#include "Color.h"
#include <SDL_ttf.h>
#include <memory>


namespace qrk
{
  /*!
    \brief フォント資源クラス
  */
  class Font
  {
    Font(void);
    Font& operator = (const Font& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultSize = 16,         //!< [pixel]
    };

    /*!
      \brief 文字サーフェスの作成

      \attention デフォルトでは背景が透過したサーフェスが作られる。変更するには transparentize() を呼び出すこと
    */
    explicit Font(const char* font_file, size_t font_size = DefaultSize,
                  bool transparent = true);
    Font(const Font& rhs);
    ~Font(void);

    TTF_Font* resource(void) const;

    void setFontSize(size_t font_size);
    size_t fontSize(void) const;

    void setForegroundColor(const Color& color);
    Color foregroundColor(void) const;

    void setBackgroundColor(const Color& color);
    Color backgroundColor(void) const;

    void setTransparent(bool on = true);
    bool transparent(void) const;
  };
}

#endif /* !QRK_FONT_H */
