/*!
  \file
  \brief 画像からサーフェスを作成

  \author Satofumi KAMIMURA

  $Id: ImageSurface.cpp 707 2009-04-04 01:52:23Z satofumi $
*/

#include "ImageSurface.h"
#include "SDL_GL_Texture.h"
#include <SDL_image.h>

using namespace qrk;


struct ImageSurface::pImpl
{
  SDL_GL_Texture texture_;
  Rect<long> rect_;


  pImpl(const char* file, bool transparent)
    : texture_(IMG_Load(file), transparent),
      rect_(0, 0, texture_.w, texture_.h)
  {
  }
};


ImageSurface::ImageSurface(const char* file, bool transparent)
  : pimpl(new pImpl(file, transparent))
{
}


ImageSurface::~ImageSurface(void)
{
}


bool ImageSurface::isValid(void) const
{
  return pimpl->texture_.isValid();
}


Rect<long> ImageSurface::rect(void) const
{
  return pimpl->rect_;
}


void ImageSurface::setAlpha(float alpha)
{
  pimpl->texture_.setAlpha(alpha);
}


float ImageSurface::alpha(void) const
{
  return pimpl->texture_.alpha();
}


void ImageSurface::draw(const Rect<long>* src, const Rect<long>* dest)
{
  if (! pimpl->texture_.isValid()) {
    return;
  }
  pimpl->texture_.blitTexture(src, dest);
}
