#ifndef QRK_LAYER_H
#define QRK_LAYER_H

/*!
  \file
  \brief 描画レイヤー

  \author Satofumi KAMIMURA

  $Id: Layer.h 708 2009-04-04 09:11:37Z satofumi $
*/

#include <memory>


namespace qrk
{
  class Component;


  class Layer
  {
    Layer(const Layer& rhs);
    Layer& operator = (const Layer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Layer(void);
    ~Layer(void);

    void clear(void);
    void push_front(Component* component);
    void push_back(Component* component);
    void remove(Component* component);
    void setAlpha(float alpha);
    void draw(void);
  };
}

#endif /* !QRK_LAYER_H */
